/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.discordrpc;

import de.erdbeerbaerlp.discordrpc.DRPCLog;
import de.erdbeerbaerlp.discordrpc.Message_Icon;
import de.erdbeerbaerlp.discordrpc.Message_Message;
import de.erdbeerbaerlp.discordrpc.ModClass;
import de.erdbeerbaerlp.discordrpc.ServerConfig;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class RequestMessage
implements IMessage {
    private String toSend;

    public RequestMessage() {
    }

    public RequestMessage(String toSend) {
        this.toSend = toSend;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.toSend);
    }

    public void fromBytes(ByteBuf buf) {
        this.toSend = buf.toString(StandardCharsets.UTF_8).trim();
    }

    public static class CommunicationMessageHandler
    implements IMessageHandler<RequestMessage, IMessage> {
        public IMessage onMessage(RequestMessage message, MessageContext ctx) {
            DRPCLog.Info("Packet received! " + message.toSend);
            if (message.toSend.equals("DRPC-Message-Request") && !ModClass.isClient) {
                System.out.println("Client requested Discord RichPresence Message... Trying to send it");
                ModClass.MSG.sendTo((IMessage)new Message_Message(ServerConfig.SERVER_MESSAGE), ctx.getServerHandler().field_147369_b);
                ModClass.ICO.sendTo((IMessage)new Message_Icon(ServerConfig.SERVER_ICON), ctx.getServerHandler().field_147369_b);
            }
            return null;
        }
    }
}

