/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.util;

import com.github.lunatrius.core.entity.EntityHelper;
import com.github.lunatrius.core.util.math.BlockPosHelper;
import com.github.lunatrius.core.util.math.MBlockPos;
import com.github.lunatrius.schematica.block.state.BlockStateHelper;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.reference.Reference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockList {
    public List<WrappedItemStack> getList(EntityPlayer player, SchematicWorld world, World mcWorld) {
        ArrayList<WrappedItemStack> blockList = new ArrayList<WrappedItemStack>();
        if (world == null) {
            return blockList;
        }
        RayTraceResult rtr = new RayTraceResult((Entity)player);
        MBlockPos mcPos = new MBlockPos();
        for (MBlockPos pos : BlockPosHelper.getAllInBox((BlockPos)BlockPos.field_177992_a, (BlockPos)new BlockPos(world.getWidth() - 1, world.func_72800_K() - 1, world.getLength() - 1))) {
            ItemStack result;
            IFluidHandler fluidHandler;
            FluidActionResult fluidActionResult;
            IBlockState blockState;
            Block block;
            if (!world.layerMode.shouldUseLayer(world, pos.func_177956_o()) || (block = (blockState = world.func_180495_p((BlockPos)pos)).func_177230_c()) == Blocks.field_150350_a || world.func_175623_d((BlockPos)pos)) continue;
            mcPos.set((Vec3i)world.position.add((Vec3i)pos));
            IBlockState mcBlockState = mcWorld.func_180495_p((BlockPos)mcPos);
            boolean isPlaced = BlockStateHelper.areBlockStatesEqual(blockState, mcBlockState);
            ItemStack stack = ItemStack.field_190927_a;
            try {
                stack = block.getPickBlock(blockState, rtr, (World)world, (BlockPos)pos, player);
            }
            catch (Exception e) {
                Reference.logger.warn("Could not get the pick block for: {}", (Object)blockState, (Object)e);
            }
            if ((block instanceof IFluidBlock || block instanceof BlockLiquid) && (fluidActionResult = FluidUtil.tryFillContainer((ItemStack)new ItemStack(Items.field_151133_ar), (IFluidHandler)(fluidHandler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, null)), (int)1000, null, (boolean)false)).isSuccess() && !(result = fluidActionResult.getResult()).func_190926_b()) {
                stack = result;
            }
            if (stack == null) {
                Reference.logger.error("Could not find the item for: {} (getPickBlock() returned null, this is a bug)", (Object)blockState);
                continue;
            }
            if (stack.func_190926_b()) {
                Reference.logger.warn("Could not find the item for: {}", (Object)blockState);
                continue;
            }
            int count = 1;
            if (block instanceof BlockSlab && ((BlockSlab)block).func_176552_j()) {
                count = 2;
            }
            WrappedItemStack wrappedItemStack = this.findOrCreateWrappedItemStackFor(blockList, stack);
            if (isPlaced) {
                wrappedItemStack.placed += count;
            }
            wrappedItemStack.total += count;
        }
        for (WrappedItemStack wrappedItemStack : blockList) {
            if (player.field_71075_bZ.field_75098_d) {
                wrappedItemStack.inventory = -1;
                continue;
            }
            wrappedItemStack.inventory = EntityHelper.getItemCountInInventory((IInventory)player.field_71071_by, (Item)wrappedItemStack.itemStack.func_77973_b(), (int)wrappedItemStack.itemStack.func_77952_i());
        }
        return blockList;
    }

    private WrappedItemStack findOrCreateWrappedItemStackFor(List<WrappedItemStack> blockList, ItemStack itemStack) {
        for (WrappedItemStack wrappedItemStack : blockList) {
            if (!wrappedItemStack.itemStack.func_77969_a(itemStack)) continue;
            return wrappedItemStack;
        }
        WrappedItemStack wrappedItemStack = new WrappedItemStack(itemStack.func_77946_l());
        blockList.add(wrappedItemStack);
        return wrappedItemStack;
    }

    public static class WrappedItemStack {
        public ItemStack itemStack;
        public int placed;
        public int total;
        public int inventory;

        public WrappedItemStack(ItemStack itemStack) {
            this(itemStack, 0, 0);
        }

        public WrappedItemStack(ItemStack itemStack, int placed, int total) {
            this.itemStack = itemStack;
            this.placed = placed;
            this.total = total;
        }

        public String getItemStackDisplayName() {
            return this.itemStack.func_77973_b().func_77653_i(this.itemStack);
        }

        public String getFormattedAmount() {
            char color = this.placed < this.total ? (char)'c' : 'a';
            return String.format("\u00a7%c%s\u00a7r/%s", Character.valueOf(color), WrappedItemStack.getFormattedStackAmount(this.itemStack, this.placed), WrappedItemStack.getFormattedStackAmount(this.itemStack, this.total));
        }

        public String getFormattedAmountMissing(String strAvailable, String strMissing) {
            int need = this.total - (this.inventory + this.placed);
            if (this.inventory != -1 && need > 0) {
                return String.format("\u00a7c%s: %s", strMissing, WrappedItemStack.getFormattedStackAmount(this.itemStack, need));
            }
            return String.format("\u00a7a%s", strAvailable);
        }

        private static String getFormattedStackAmount(ItemStack itemStack, int amount) {
            int stackSize = itemStack.func_77976_d();
            return String.format("%d", amount);
        }
    }
}

