/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.handler.client;

import com.github.lunatrius.schematica.block.state.BlockStateHelper;
import com.github.lunatrius.schematica.client.renderer.RenderSchematic;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class OverlayHandler {
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private static final String SCHEMATICA_PREFIX = "[" + TextFormatting.GOLD + "Schematica" + TextFormatting.RESET + "] ";
    private static final String SCHEMATICA_SUFFIX = " [" + TextFormatting.GOLD + "S" + TextFormatting.RESET + "]";

    @SubscribeEvent
    public void onText(RenderGameOverlayEvent.Text event) {
        SchematicWorld schematic;
        if (this.minecraft.field_71474_y.field_74330_P && ConfigurationHandler.showDebugInfo && (schematic = ClientProxy.schematic) != null && schematic.isRendering) {
            ArrayList left = event.getLeft();
            ArrayList right = event.getRight();
            left.add("");
            left.add(SCHEMATICA_PREFIX + schematic.getDebugDimensions());
            left.add(SCHEMATICA_PREFIX + RenderSchematic.INSTANCE.getDebugInfoTileEntities());
            left.add(SCHEMATICA_PREFIX + RenderSchematic.INSTANCE.func_72735_c());
            RayTraceResult rtr = ClientProxy.objectMouseOver;
            if (rtr != null && rtr.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos origPos;
                BlockPos pos = rtr.func_178782_a();
                IBlockState blockState = schematic.func_180495_p(pos);
                right.add("");
                right.add(String.valueOf(Block.field_149771_c.func_177774_c((Object)blockState.func_177230_c())) + SCHEMATICA_SUFFIX);
                for (String formattedProperty : BlockStateHelper.getFormattedProperties(blockState)) {
                    right.add(formattedProperty + SCHEMATICA_SUFFIX);
                }
                BlockPos offsetPos = pos.func_177971_a((Vec3i)schematic.position);
                String lookMessage = String.format("Looking at: %d %d %d (%d %d %d)", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), offsetPos.func_177958_n(), offsetPos.func_177956_o(), offsetPos.func_177952_p());
                if (this.minecraft.field_71476_x != null && this.minecraft.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK && offsetPos.equals((Object)(origPos = this.minecraft.field_71476_x.func_178782_a()))) {
                    lookMessage = lookMessage + " (matches)";
                }
                left.add(SCHEMATICA_PREFIX + lookMessage);
            }
        }
    }
}

