/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.handler.client;

import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class RenderTickHandler {
    public static final RenderTickHandler INSTANCE = new RenderTickHandler();
    private final Minecraft minecraft = Minecraft.func_71410_x();

    private RenderTickHandler() {
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        SchematicWorld schematic = ClientProxy.schematic;
        ClientProxy.objectMouseOver = schematic != null ? this.rayTrace(schematic, 1.0f) : null;
    }

    private RayTraceResult rayTrace(SchematicWorld schematic, float partialTicks) {
        Entity renderViewEntity = this.minecraft.func_175606_aa();
        if (renderViewEntity == null) {
            return null;
        }
        double blockReachDistance = this.minecraft.field_71442_b.func_78757_d();
        double posX = renderViewEntity.field_70165_t;
        double posY = renderViewEntity.field_70163_u;
        double posZ = renderViewEntity.field_70161_v;
        renderViewEntity.field_70165_t -= (double)schematic.position.field_177962_a;
        renderViewEntity.field_70163_u -= (double)schematic.position.field_177960_b;
        renderViewEntity.field_70161_v -= (double)schematic.position.field_177961_c;
        Vec3d vecPosition = renderViewEntity.func_174824_e(partialTicks);
        Vec3d vecLook = renderViewEntity.func_70676_i(partialTicks);
        Vec3d vecExtendedLook = vecPosition.func_72441_c(vecLook.field_72450_a * blockReachDistance, vecLook.field_72448_b * blockReachDistance, vecLook.field_72449_c * blockReachDistance);
        renderViewEntity.field_70165_t = posX;
        renderViewEntity.field_70163_u = posY;
        renderViewEntity.field_70161_v = posZ;
        return schematic.func_147447_a(vecPosition, vecExtendedLook, false, false, true);
    }
}

