/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.world.schematic;

import com.github.lunatrius.schematica.reference.Reference;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public final class SchematicUtil {
    public static final ItemStack DEFAULT_ICON = new ItemStack((Block)Blocks.field_150349_c);

    public static NBTTagCompound readTagCompoundFromFile(File file) throws IOException {
        try {
            return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        }
        catch (Exception ex) {
            Reference.logger.warn("Failed compressed read, trying normal read...", (Throwable)ex);
            return CompressedStreamTools.func_74797_a((File)file);
        }
    }

    public static ItemStack getIconFromName(String iconName) {
        ResourceLocation rl = null;
        int damage = 0;
        String[] parts = iconName.split(",");
        if (parts.length >= 1) {
            rl = new ResourceLocation(parts[0]);
            if (parts.length >= 2) {
                try {
                    damage = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (rl == null) {
            return DEFAULT_ICON.func_77946_l();
        }
        ItemStack block = new ItemStack((Block)Block.field_149771_c.func_82594_a((Object)rl), 1, damage);
        if (!block.func_190926_b()) {
            return block;
        }
        ItemStack item = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)rl), 1, damage);
        if (!item.func_190926_b()) {
            return item;
        }
        return DEFAULT_ICON.func_77946_l();
    }

    public static ItemStack getIconFromNBT(NBTTagCompound tagCompound) {
        ItemStack icon = DEFAULT_ICON.func_77946_l();
        if (tagCompound != null && tagCompound.func_74764_b("Icon")) {
            icon.deserializeNBT(tagCompound.func_74775_l("Icon"));
            if (icon.func_190926_b()) {
                icon = DEFAULT_ICON.func_77946_l();
            }
        }
        return icon;
    }

    public static ItemStack getIconFromFile(File file) {
        try {
            return SchematicUtil.getIconFromNBT(SchematicUtil.readTagCompoundFromFile(file));
        }
        catch (Exception e) {
            Reference.logger.error("Failed to read schematic icon!", (Throwable)e);
            return DEFAULT_ICON.func_77946_l();
        }
    }
}

