/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.api.IEMPAffected;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordConvertible;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.PortableRadarBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.DisplayCaseBlock;
import net.geforcemods.securitycraft.blocks.RiftStabilizerBlock;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.blocks.SonicSecuritySystemBlock;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.items.UniversalBlockReinforcerItem;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.PortalSize;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.misc.SCWorldListener;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNote;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.MutablePair;

@Mod.EventBusSubscriber(modid="securitycraft")
public class SCEventHandler {
    public static HashMap<String, String> tipsWithLink = new HashMap();
    private static final Integer NOTE_DELAY = 9;
    public static final Map<EntityPlayer, MutablePair<Integer, Deque<SonicSecuritySystemBlockEntity.NoteWrapper>>> PLAYING_TUNES = new HashMap<EntityPlayer, MutablePair<Integer, Deque<SonicSecuritySystemBlockEntity.NoteWrapper>>>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            PLAYING_TUNES.forEach((player, pair) -> {
                int ticksRemaining = (Integer)pair.getLeft();
                if (ticksRemaining == 0) {
                    if (PlayerUtils.getSelectedItemStack(player, SCContent.portableTunePlayer).func_190926_b()) {
                        pair.setLeft((Object)-1);
                        return;
                    }
                    SonicSecuritySystemBlockEntity.NoteWrapper note = (SonicSecuritySystemBlockEntity.NoteWrapper)((Deque)pair.getRight()).poll();
                    if (note != null) {
                        SoundEvent sound = ((BlockNote)Blocks.field_150323_B).func_185576_e(NoteBlockEvent.Instrument.valueOf((String)note.instrumentName.toUpperCase()).ordinal());
                        float pitch = (float)Math.pow(2.0, (double)(note.noteID - 12) / 12.0);
                        player.field_70170_p.func_184133_a(null, player.func_180425_c(), sound, SoundCategory.RECORDS, 3.0f, pitch);
                        SCEventHandler.handlePlayedNote(player.field_70170_p, player.func_180425_c(), note.noteID, note.instrumentName);
                        pair.setLeft((Object)NOTE_DELAY);
                    } else {
                        pair.setLeft((Object)-1);
                    }
                } else {
                    pair.setLeft((Object)(ticksRemaining - 1));
                }
            });
            if (PLAYING_TUNES.size() > 0) {
                Iterator<Map.Entry<EntityPlayer, MutablePair<Integer, Deque<SonicSecuritySystemBlockEntity.NoteWrapper>>>> entries = PLAYING_TUNES.entrySet().iterator();
                while (entries.hasNext()) {
                    if ((Integer)entries.next().getValue().left != -1) continue;
                    entries.remove();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (ConfigHandler.sayThanksMessage) {
            String tipKey = SCEventHandler.getRandomTip();
            ITextComponent message = new TextComponentString("[" + TextFormatting.GOLD + "SecurityCraft" + TextFormatting.WHITE + "] ").func_150257_a((ITextComponent)Utils.localize("messages.securitycraft:thanks", SecurityCraft.getVersion())).func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a((ITextComponent)Utils.localize("messages.securitycraft:tip", new Object[0])).func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a((ITextComponent)Utils.localize(tipKey, new Object[0]));
            if (tipsWithLink.containsKey(tipKey.split("\\.")[2])) {
                message.func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a(ForgeHooks.newChatWithLinks((String)tipsWithLink.get(tipKey.split("\\.")[2])));
            }
            event.player.func_145747_a(message);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        if (player.func_175398_C() instanceof SecurityCamera) {
            SecurityCamera cam = (SecurityCamera)player.func_175398_C();
            TileEntity tile = player.field_70170_p.func_175625_s(new BlockPos(cam.field_70165_t, cam.field_70163_u, cam.field_70161_v));
            if (tile instanceof SecurityCameraBlockEntity) {
                ((SecurityCameraBlockEntity)tile).stopViewing();
            }
            cam.func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (event.getSource() == CustomDamageSources.ELECTRICITY) {
            world.func_184133_a(null, entity.func_180425_c(), SCSounds.ELECTRIFIED.event, SoundCategory.BLOCKS, 0.25f, 1.0f);
        }
        if (!world.field_72995_K && entity instanceof EntityPlayerMP && PlayerUtils.isPlayerMountedOnCamera(entity)) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            ((SecurityCamera)player.func_175398_C()).stopViewing(player);
        }
    }

    @SubscribeEvent
    public static void onBucketUsed(FillBucketEvent event) {
        ItemStack result;
        BlockPos pos;
        if (event.getTarget() == null) {
            return;
        }
        World world = event.getWorld();
        Block block = world.func_180495_p(pos = event.getTarget().func_178782_a()).func_177230_c();
        if (block == SCContent.fakeWater) {
            result = new ItemStack(SCContent.fWaterBucket, 1);
        } else if (block == SCContent.fakeLava) {
            result = new ItemStack(SCContent.fLavaBucket, 1);
        } else {
            return;
        }
        world.func_175698_g(pos);
        event.setFilledBucket(result);
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void highestPriorityOnRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (!(stack.func_190926_b() || item == SCContent.adminTool || item == SCContent.codebreaker || item == SCContent.universalBlockRemover || item == SCContent.universalBlockModifier || item == SCContent.universalKeyChanger || item == SCContent.universalOwnerChanger || item instanceof ModuleItem || item instanceof ItemBlock)) {
            Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
            if (block == SCContent.keypadDoor) {
                event.setUseItem(Event.Result.DENY);
            } else if (block == SCContent.reinforcedDoor || block == SCContent.reinforcedIronTrapdoor || block == SCContent.scannerDoor) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Object ownable;
        Owner owner;
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntityPlayer())) {
            event.setCanceled(true);
            return;
        }
        World world = event.getWorld();
        TileEntity te = world.func_175625_s(event.getPos());
        IBlockState state = world.func_180495_p(event.getPos());
        Block block = state.func_177230_c();
        if (te instanceof ILockable && ((ILockable)te).isLocked() && ((ILockable)te).disableInteractionWhenLocked(world, event.getPos(), event.getEntityPlayer()) && !event.getEntityPlayer().func_70093_af()) {
            if (event.getHand() == EnumHand.MAIN_HAND) {
                PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize(block, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:sonic_security_system.locked", Utils.localize(block, new Object[0])), TextFormatting.DARK_RED, false);
            }
            event.setCanceled(true);
            return;
        }
        if (te instanceof IOwnable && !(owner = (ownable = (IOwnable)te).getOwner()).isValidated()) {
            if (ownable.isOwnedBy(event.getEntityPlayer())) {
                owner.setValidated(true);
                PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize(block.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:ownable.validate", new Object[0]), TextFormatting.GREEN);
            } else {
                PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize(block.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:ownable.ownerNotValidated", new Object[0]), TextFormatting.RED);
            }
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            return;
        }
        if (event.getItemStack().func_77973_b() == Items.field_151137_ax && te instanceof IEMPAffected && ((IEMPAffected)te).isShutDown()) {
            ((IEMPAffected)te).reactivate();
            if (!event.getEntityPlayer().func_184812_l_()) {
                event.getItemStack().func_190918_g(1);
            }
            event.getEntityPlayer().func_184609_a(event.getHand());
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            return;
        }
        if (PlayerUtils.isHoldingItem(event.getEntityPlayer(), SCContent.keyPanel, event.getHand())) {
            for (IPasswordConvertible pc : SecurityCraftAPI.getRegisteredPasswordConvertibles()) {
                if (!pc.isValidStateForConversion(state)) continue;
                event.setUseBlock(Event.Result.DENY);
                event.setUseItem(Event.Result.ALLOW);
            }
            return;
        }
        if (PlayerUtils.isHoldingItem(event.getEntityPlayer(), SCContent.codebreaker, event.getHand()) && SCEventHandler.handleCodebreaking(event)) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            return;
        }
        if (PlayerUtils.isHoldingItem(event.getEntityPlayer(), SCContent.universalBlockModifier, event.getHand()) && te instanceof IModuleInventory) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            if (te instanceof IOwnable && !((IOwnable)te).isOwnedBy(event.getEntityPlayer())) {
                if (!(te.func_145838_q() instanceof DisguisableBlock) || ((ItemBlock)((DisguisableBlock)te.func_145838_q()).getDisguisedStack((IBlockAccess)world, event.getPos()).func_77973_b()).func_179223_d() instanceof DisguisableBlock) {
                    PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize("item.securitycraft:universalBlockModifier.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(((IOwnable)te).getOwner())), TextFormatting.RED);
                }
                return;
            }
            event.getEntityPlayer().openGui((Object)SecurityCraft.instance, 100, world, event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p());
            return;
        }
        if (te instanceof INameSetter && (te instanceof SecurityCameraBlockEntity || te instanceof PortableRadarBlockEntity) && PlayerUtils.isHoldingItem(event.getEntityPlayer(), Items.field_151057_cb, event.getHand()) && event.getEntityPlayer().func_184586_b(event.getHand()).func_82837_s()) {
            ItemStack nametag = event.getEntityPlayer().func_184586_b(event.getHand());
            INameSetter nameable = (INameSetter)te;
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
            if (nameable.func_70005_c_().equals(nametag.func_82833_r())) {
                PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize(event.getWorld().func_180495_p(event.getPos()).func_177230_c().func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:naming.alreadyMatches", nameable.func_145748_c_()), TextFormatting.RED);
                return;
            }
            if (!event.getEntityPlayer().func_184812_l_()) {
                nametag.func_190918_g(1);
            }
            if (!world.field_72995_K) {
                nameable.setCustomName(nametag.func_82833_r());
            }
            PlayerUtils.sendMessageToPlayer(event.getEntityPlayer(), (ITextComponent)Utils.localize(event.getWorld().func_180495_p(event.getPos()).func_177230_c().func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:naming.named", nameable.func_145748_c_()), TextFormatting.GREEN);
            return;
        }
        if (block instanceof DisplayCaseBlock && event.getEntity().func_70093_af() && event.getEntityPlayer().func_184614_ca().func_190926_b() && !event.getEntityPlayer().func_184592_cb().func_190926_b()) {
            event.setUseBlock(Event.Result.ALLOW);
            event.setUseItem(Event.Result.DENY);
            return;
        }
        List sentries = world.func_72872_a(Sentry.class, new AxisAlignedBB(event.getPos()));
        if (!sentries.isEmpty()) {
            event.setCanceled(((Sentry)sentries.get(0)).func_184645_a(event.getEntityPlayer(), event.getHand()));
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntityPlayer())) {
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.FAIL);
            return;
        }
        ItemStack stack = event.getEntityPlayer().func_184614_ca();
        Item held = stack.func_77973_b();
        if (held == SCContent.universalBlockReinforcerLvL1 || held == SCContent.universalBlockReinforcerLvL2 || held == SCContent.universalBlockReinforcerLvL3) {
            UniversalBlockReinforcerItem.convertBlock(stack, event.getPos(), event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public static void onBlockEventBreak(BlockEvent.BreakEvent event) {
        List sentries;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (event.getPlayer().func_184812_l_() && !(sentries = world.func_72872_a(Sentry.class, new AxisAlignedBB(event.getPos()))).isEmpty()) {
            event.setCanceled(true);
            return;
        }
        if (!world.field_72995_K) {
            IModuleInventory te;
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof IModuleInventory && (te = (IModuleInventory)tile).shouldDropModules()) {
                int i = 100;
                while (i - 100 < te.getMaxNumberOfModules()) {
                    if (!te.getStackInSlot(i).func_190926_b()) {
                        ItemStack stack = te.getStackInSlot(i);
                        EntityItem item = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                        LevelUtils.addScheduledTask(world, () -> world.func_72838_d((Entity)item));
                        te.onModuleRemoved(stack, ((ModuleItem)stack.func_77973_b()).getModuleType(), false);
                        if (te instanceof LinkableBlockEntity) {
                            LinkableBlockEntity linkable = (LinkableBlockEntity)te;
                            linkable.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleRemoved(((ModuleItem)stack.func_77973_b()).getModuleType(), false), linkable);
                        }
                        if (te instanceof SecurityCameraBlockEntity) {
                            SecurityCameraBlockEntity cam = (SecurityCameraBlockEntity)te;
                            cam.func_145831_w().func_175685_c(cam.func_174877_v().func_177967_a((EnumFacing)cam.func_145831_w().func_180495_p(cam.func_174877_v()).func_177229_b((IProperty)SecurityCameraBlock.FACING), -1), cam.func_145831_w().func_180495_p(cam.func_174877_v()).func_177230_c(), true);
                        }
                    }
                    ++i;
                }
            }
            EntityPlayer player = event.getPlayer();
            IBlockState state = event.getState();
            BlockEntityTracker.BLOCK_CHANGE_DETECTOR.getTileEntitiesInRange(world, pos).forEach(detector -> detector.log(player, BlockChangeDetectorBlockEntity.EnumDetectionMode.BREAK, pos, state));
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("securitycraft")) {
            ConfigManager.sync((String)"securitycraft", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void onOwnership(OwnershipEvent event) {
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (te instanceof IOwnable) {
            String name = event.getPlayer().func_70005_c_();
            String uuid = event.getPlayer().func_146103_bH().getId().toString();
            ((IOwnable)te).setOwner(uuid, name);
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.PlaceEvent event) {
        World world = event.getWorld();
        if (event.getState().func_177230_c() == Blocks.field_150480_ab && world.func_180495_p(event.getPos().func_177977_b()).func_177230_c() == SCContent.reinforcedObsidian) {
            PortalSize portalSize = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.X);
            if (portalSize.isValid() && portalSize.getPortalBlockCount() == 0) {
                portalSize.placePortalBlocks();
            } else {
                portalSize = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.Z);
                if (portalSize.isValid() && portalSize.getPortalBlockCount() == 0) {
                    portalSize.placePortalBlocks();
                }
            }
        }
        if (!world.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            BlockPos pos = event.getPos();
            IBlockState state = event.getState();
            BlockEntityTracker.BLOCK_CHANGE_DETECTOR.getTileEntitiesInRange(world, pos).forEach(detector -> detector.log((EntityPlayer)event.getEntity(), BlockChangeDetectorBlockEntity.EnumDetectionMode.PLACE, pos, state));
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getWorld().field_72995_K) {
            BlockPos pos = event.getEntity().func_180425_c();
            do {
                Object portalSize;
                if (event.getWorld().func_180495_p(pos).func_177230_c() == Blocks.field_150343_Z) {
                    portalSize = new BlockPortal.Size(event.getWorld(), pos, EnumFacing.Axis.X);
                    if (portalSize.func_150860_b()) {
                        double y = (double)pos.func_177956_o() + 0.5;
                        if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                            y -= 3.0;
                        }
                        event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                        break;
                    }
                    portalSize = new BlockPortal.Size(event.getWorld(), pos, EnumFacing.Axis.Z);
                    if (!portalSize.func_150860_b()) continue;
                    double y = (double)pos.func_177956_o() + 0.5;
                    if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                        y -= 3.0;
                    }
                    event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                    break;
                }
                if (event.getWorld().func_180495_p(pos).func_177230_c() != SCContent.reinforcedObsidian) continue;
                portalSize = new PortalSize(event.getWorld(), pos, EnumFacing.Axis.X);
                if (((PortalSize)portalSize).isValid()) {
                    double y = (double)pos.func_177956_o() + 0.5;
                    if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                        y -= 3.0;
                    }
                    event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                    break;
                }
                portalSize = new PortalSize(event.getWorld(), pos, EnumFacing.Axis.Z);
                if (!((PortalSize)portalSize).isValid()) continue;
                double y = (double)pos.func_177956_o() + 0.5;
                if (event.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                    y -= 3.0;
                }
                event.getEntity().func_70107_b((double)pos.func_177958_n() + 0.5, y, (double)pos.func_177952_p() + 0.5);
                break;
            } while ((pos = pos.func_177984_a()).func_177956_o() < Math.min(event.getWorld().func_72800_K(), 256));
        }
    }

    @SubscribeEvent
    public static void onNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        if (event.getState().func_177230_c() == Blocks.field_150427_aO) {
            PortalSize portalSize;
            EnumFacing.Axis axis = (EnumFacing.Axis)event.getState().func_177229_b((IProperty)BlockPortal.field_176550_a);
            if (axis == EnumFacing.Axis.X) {
                PortalSize portalSize2 = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.X);
                if (portalSize2.isValid() || portalSize2.getPortalBlockCount() > portalSize2.getWidth() * portalSize2.getHeight()) {
                    event.setCanceled(true);
                }
            } else if (axis == EnumFacing.Axis.Z && ((portalSize = new PortalSize(event.getWorld(), event.getPos(), EnumFacing.Axis.Z)).isValid() || portalSize.getPortalBlockCount() > portalSize.getWidth() * portalSize.getHeight())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            return;
        }
        if (event.getTarget() instanceof Sentry) {
            ((EntityLiving)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)new SCWorldListener());
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)event.getEntityPlayer()) && event.getItemStack().func_77973_b() != SCContent.cameraMonitor) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDestroyEvent(LivingDestroyBlockEvent event) {
        event.setCanceled(event.getEntity() instanceof EntityWither && event.getState().func_177230_c() instanceof IReinforcedBlock);
    }

    @SubscribeEvent
    public static void onEntityTeleport(EnderTeleportEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        Vec3d target = new Vec3d(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        event.setCanceled(SCEventHandler.handleEntityTeleport(entity, entity.func_174791_d(), target, RiftStabilizerBlockEntity.TeleportationType.getTypeFromEvent(entity, target)));
    }

    public static boolean handleEntityTeleport(EntityLivingBase entity, Vec3d source, Vec3d target, RiftStabilizerBlockEntity.TeleportationType type) {
        World world = entity.func_130014_f_();
        List<RiftStabilizerBlockEntity> targetPosTileEntities = BlockEntityTracker.RIFT_STABILIZER.getTileEntitiesInRange(world, target);
        List<RiftStabilizerBlockEntity> sourcePosTileEntities = BlockEntityTracker.RIFT_STABILIZER.getTileEntitiesInRange(world, source);
        List<Object> tileEntities = new ArrayList<RiftStabilizerBlockEntity>();
        RiftStabilizerBlockEntity riftStabilizer = null;
        boolean targetPosProhibited = false;
        tileEntities.addAll(targetPosTileEntities);
        tileEntities.addAll(sourcePosTileEntities);
        tileEntities = tileEntities.stream().distinct().sorted(Comparator.comparingDouble(t -> Math.min(t.func_174877_v().func_177957_d(target.field_72450_a, target.field_72448_b, target.field_72449_c), t.func_174877_v().func_177957_d(source.field_72450_a, source.field_72448_b, source.field_72449_c)))).collect(Collectors.toList());
        for (RiftStabilizerBlockEntity riftStabilizerBlockEntity : tileEntities) {
            if (riftStabilizerBlockEntity.isDisabled() || !riftStabilizerBlockEntity.getFilter(type) || entity instanceof EntityPlayer && (riftStabilizerBlockEntity.isOwnedBy((EntityPlayer)entity) && riftStabilizerBlockEntity.ignoresOwner() || riftStabilizerBlockEntity.isAllowed((Entity)entity))) continue;
            riftStabilizer = riftStabilizerBlockEntity;
            targetPosProhibited = riftStabilizerBlockEntity.func_174877_v().func_177957_d(target.field_72450_a, target.field_72448_b, target.field_72449_c) < riftStabilizerBlockEntity.func_174877_v().func_177957_d(source.field_72450_a, source.field_72448_b, source.field_72449_c);
            break;
        }
        if (riftStabilizer != null) {
            BlockPos pos = riftStabilizer.func_174877_v();
            Vec3d vec3d = new AxisAlignedBB(pos).func_189972_c();
            Vec3d from = targetPosProhibited ? target : source;
            Vec3d distance = from.func_178788_d(vec3d);
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                world.func_184148_a(null, source.field_72450_a, source.field_72448_b, source.field_72449_c, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.5f);
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.riftStabilizer.func_149739_a() + ".name", new Object[0]), (ITextComponent)Utils.localize(targetPosProhibited ? "messages.securitycraft:rift_stabilizer.no_teleport_to" : "messages.securitycraft:rift_stabilizer.no_teleport_from", new Object[0]), TextFormatting.RED);
                if (riftStabilizer.isModuleEnabled(ModuleType.HARMING)) {
                    player.func_70097_a(DamageSource.field_76379_h, 5.0f);
                }
            }
            riftStabilizer.setLastTeleport(Math.max(Math.abs(distance.field_72450_a), Math.max(Math.abs(distance.field_72448_b), Math.abs(distance.field_72449_c))) - 0.5, type);
            if (riftStabilizer.isModuleEnabled(ModuleType.REDSTONE)) {
                world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)RiftStabilizerBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                BlockUtils.updateIndirectNeighbors(world, pos, SCContent.riftStabilizer);
                world.func_175684_a(pos, SCContent.riftStabilizer, riftStabilizer.getSignalLength());
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onNoteBlockPlayed(NoteBlockEvent.Play event) {
        SCEventHandler.handlePlayedNote(event.getWorld(), event.getPos(), event.getVanillaNoteId(), event.getInstrument().name());
    }

    private static void handlePlayedNote(World world, BlockPos pos, int vanillaNoteId, String instrumentName) {
        List<SonicSecuritySystemBlockEntity> sonicSecuritySystems = BlockEntityTracker.SONIC_SECURITY_SYSTEM.getTileEntitiesInRange(world, pos);
        for (SonicSecuritySystemBlockEntity te : sonicSecuritySystems) {
            if (!te.isActive()) continue;
            if (te.isRecording()) {
                te.recordNote(vanillaNoteId, instrumentName);
                continue;
            }
            if (!te.listenToNote(vanillaNoteId, instrumentName)) continue;
            te.correctTuneWasPlayed = true;
            te.powerCooldown = (Integer)te.signalLength.get();
            if (!te.isModuleEnabled(ModuleType.REDSTONE)) continue;
            world.func_175656_a(te.func_174877_v(), te.func_145831_w().func_180495_p(te.func_174877_v()).func_177226_a((IProperty)SonicSecuritySystemBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            BlockUtils.updateIndirectNeighbors(world, te.func_174877_v(), SCContent.sonicSecuritySystem, EnumFacing.DOWN);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean handleCodebreaking(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        BlockPos pos = event.getPos();
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof ICodebreakable)) return false;
        double chance = ConfigHandler.codebreakerChance;
        if (chance < 0.0) {
            Block block = world.func_180495_p(pos).func_177230_c();
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(block, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), TextFormatting.RED);
            return true;
        }
        ICodebreakable codebreakable = (ICodebreakable)tileEntity;
        ItemStack stackInHand = player.func_184586_b(event.getHand());
        IBlockState state = world.func_180495_p(pos);
        if (!codebreakable.shouldAttemptCodebreak(state, player)) {
            return true;
        }
        if (stackInHand.func_77973_b() == SCContent.codebreaker) {
            stackInHand.func_77972_a(1, (EntityLivingBase)player);
        }
        if (!player.func_184812_l_()) {
            if (!(new Random().nextDouble() < chance)) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.codebreaker, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), TextFormatting.RED);
                return true;
            }
        }
        codebreakable.useCodebreaker(state, player);
        return true;
    }

    private static String getRandomTip() {
        String[] tips = new String[]{"messages.securitycraft:tip.scHelp", "messages.securitycraft:tip.patreon", "messages.securitycraft:tip.discord", "messages.securitycraft:tip.scserver", "messages.securitycraft:tip.outdated"};
        return tips[new Random().nextInt(SCEventHandler.isOutdated() ? tips.length : tips.length - 1)];
    }

    private static boolean isOutdated() {
        return ForgeVersion.getResult((ModContainer)Loader.instance().activeModContainer()).status == ForgeVersion.Status.OUTDATED;
    }

    static {
        tipsWithLink.put("patreon", "https://www.patreon.com/Geforce");
        tipsWithLink.put("discord", "https://discord.gg/U8DvBAW");
        tipsWithLink.put("outdated", "https://www.curseforge.com/minecraft/mc-mods/security-craft/files/all");
    }
}

