/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.lang.reflect.Field;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.RegistrationHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SetupHandler;
import net.geforcemods.securitycraft.TileEntityIDDataFixer;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.KeypadBlock;
import net.geforcemods.securitycraft.blocks.KeypadChestBlock;
import net.geforcemods.securitycraft.blocks.KeypadFurnaceBlock;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedHopperBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedMetalsBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPressurePlateBlock;
import net.geforcemods.securitycraft.commands.SCCommand;
import net.geforcemods.securitycraft.compat.cyclic.CyclicCompat;
import net.geforcemods.securitycraft.compat.icbmclassic.ICBMClassicEMPCompat;
import net.geforcemods.securitycraft.compat.lycanitesmobs.LycanitesMobsCompat;
import net.geforcemods.securitycraft.compat.projecte.ProjectECompat;
import net.geforcemods.securitycraft.compat.versionchecker.VersionUpdateChecker;
import net.geforcemods.securitycraft.itemgroups.SCDecorationTab;
import net.geforcemods.securitycraft.itemgroups.SCExplosivesTab;
import net.geforcemods.securitycraft.itemgroups.SCTechnicalTab;
import net.geforcemods.securitycraft.misc.CommonDoorActivator;
import net.geforcemods.securitycraft.misc.ConfigAttackTargetCheck;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.IProxy;
import net.geforcemods.securitycraft.screen.ScreenHandler;
import net.geforcemods.securitycraft.util.Reinforced;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="securitycraft", name="SecurityCraft", dependencies="required-after:forge@[14.23.5.2826,)", updateJSON="https://www.github.com/Geforce132/SecurityCraft/raw/master/Updates/Forge.json", acceptedMinecraftVersions="[1.12.2]")
public class SecurityCraft {
    public static final String MODID = "securitycraft";
    @SidedProxy(clientSide="net.geforcemods.securitycraft.network.ClientProxy", serverSide="net.geforcemods.securitycraft.network.ServerProxy")
    public static IProxy proxy;
    @Mod.Instance(value="securitycraft")
    public static SecurityCraft instance;
    public static SimpleNetworkWrapper network;
    private ScreenHandler guiHandler = new ScreenHandler();
    public static CreativeTabs tabSCTechnical;
    public static CreativeTabs tabSCMine;
    public static CreativeTabs tabSCDecoration;

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new SCCommand());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        RegistrationHandler.registerPackets(network);
        SetupHandler.setupBlocks();
        SetupHandler.setupMines();
        SetupHandler.setupItems();
        proxy.registerEntityRenderingHandlers();
        if (Loader.isModLoaded((String)"icbmclassic")) {
            MinecraftForge.EVENT_BUS.register((Object)new ICBMClassicEMPCompat());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NBTTagCompound vcUpdateTag;
        FMLInterModComms.sendFunctionMessage((String)MODID, (String)"registerExtractionBlock", (String)ReinforcedHopperBlock.ExtractionBlock.class.getName());
        FMLInterModComms.sendFunctionMessage((String)MODID, (String)"registerPasswordConvertible", (String)KeypadBlock.Convertible.class.getName());
        FMLInterModComms.sendFunctionMessage((String)MODID, (String)"registerPasswordConvertible", (String)KeypadChestBlock.Convertible.class.getName());
        FMLInterModComms.sendFunctionMessage((String)MODID, (String)"registerPasswordConvertible", (String)KeypadFurnaceBlock.Convertible.class.getName());
        FMLInterModComms.sendFunctionMessage((String)MODID, (String)"registerSentryAttackTargetCheck", (String)ConfigAttackTargetCheck.class.getName());
        FMLInterModComms.sendFunctionMessage((String)MODID, (String)"registerDoorActivator", (String)CommonDoorActivator.class.getName());
        FMLInterModComms.sendFunctionMessage((String)MODID, (String)"registerDoorActivator", (String)InventoryScannerBlock.DoorActivator.class.getName());
        FMLInterModComms.sendFunctionMessage((String)MODID, (String)"registerDoorActivator", (String)ReinforcedPressurePlateBlock.DoorActivator.class.getName());
        FMLInterModComms.sendFunctionMessage((String)MODID, (String)"registerDoorActivator", (String)ReinforcedMetalsBlock.DoorActivator.class.getName());
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"net.geforcemods.securitycraft.compat.waila.WailaDataProvider.callbackRegister");
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"net.geforcemods.securitycraft.compat.top.TOPDataProvider");
        if (Loader.isModLoaded((String)"lycanitesmobs")) {
            FMLInterModComms.sendFunctionMessage((String)MODID, (String)"registerSentryAttackTargetCheck", (String)LycanitesMobsCompat.class.getName());
        }
        if (ConfigHandler.checkForUpdates && (vcUpdateTag = VersionUpdateChecker.getNBTTagCompound()) != null) {
            FMLInterModComms.sendRuntimeMessage((Object)MODID, (String)"VersionChecker", (String)"addUpdate", (NBTTagCompound)vcUpdateTag);
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)this.guiHandler);
        ModuleType.refresh();
        proxy.registerRenderThings();
        FMLCommonHandler.instance().getDataFixer().init(MODID, 1).registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileEntityIDDataFixer());
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedCobblestone), (ItemStack)new ItemStack(SCContent.reinforcedStone, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedSand, 1, 0), (ItemStack)new ItemStack(SCContent.reinforcedGlass, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedSand, 1, 1), (ItemStack)new ItemStack(SCContent.reinforcedGlass, 1, 0), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStoneBrick, 1, 0), (ItemStack)new ItemStack(SCContent.reinforcedStoneBrick, 1, 2), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedClay, 1, 0), (ItemStack)new ItemStack(SCContent.reinforcedHardenedClay, 1, 0), (float)0.35f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStainedHardenedClay, 1, EnumDyeColor.WHITE.func_176765_a()), (ItemStack)new ItemStack(SCContent.reinforcedWhiteGlazedTerracotta), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStainedHardenedClay, 1, EnumDyeColor.ORANGE.func_176765_a()), (ItemStack)new ItemStack(SCContent.reinforcedOrangeGlazedTerracotta), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStainedHardenedClay, 1, EnumDyeColor.MAGENTA.func_176765_a()), (ItemStack)new ItemStack(SCContent.reinforcedMagentaGlazedTerracotta), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStainedHardenedClay, 1, EnumDyeColor.LIGHT_BLUE.func_176765_a()), (ItemStack)new ItemStack(SCContent.reinforcedLightBlueGlazedTerracotta), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStainedHardenedClay, 1, EnumDyeColor.YELLOW.func_176765_a()), (ItemStack)new ItemStack(SCContent.reinforcedYellowGlazedTerracotta), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStainedHardenedClay, 1, EnumDyeColor.LIME.func_176765_a()), (ItemStack)new ItemStack(SCContent.reinforcedLimeGlazedTerracotta), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStainedHardenedClay, 1, EnumDyeColor.PINK.func_176765_a()), (ItemStack)new ItemStack(SCContent.reinforcedPinkGlazedTerracotta), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStainedHardenedClay, 1, EnumDyeColor.GRAY.func_176765_a()), (ItemStack)new ItemStack(SCContent.reinforcedGrayGlazedTerracotta), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStainedHardenedClay, 1, EnumDyeColor.SILVER.func_176765_a()), (ItemStack)new ItemStack(SCContent.reinforcedSilverGlazedTerracotta), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStainedHardenedClay, 1, EnumDyeColor.CYAN.func_176765_a()), (ItemStack)new ItemStack(SCContent.reinforcedCyanGlazedTerracotta), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStainedHardenedClay, 1, EnumDyeColor.PURPLE.func_176765_a()), (ItemStack)new ItemStack(SCContent.reinforcedPurpleGlazedTerracotta), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStainedHardenedClay, 1, EnumDyeColor.BLUE.func_176765_a()), (ItemStack)new ItemStack(SCContent.reinforcedBlueGlazedTerracotta), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStainedHardenedClay, 1, EnumDyeColor.BROWN.func_176765_a()), (ItemStack)new ItemStack(SCContent.reinforcedBrownGlazedTerracotta), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStainedHardenedClay, 1, EnumDyeColor.GREEN.func_176765_a()), (ItemStack)new ItemStack(SCContent.reinforcedGreenGlazedTerracotta), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStainedHardenedClay, 1, EnumDyeColor.RED.func_176765_a()), (ItemStack)new ItemStack(SCContent.reinforcedRedGlazedTerracotta), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(SCContent.reinforcedStainedHardenedClay, 1, EnumDyeColor.BLACK.func_176765_a()), (ItemStack)new ItemStack(SCContent.reinforcedBlackGlazedTerracotta), (float)0.1f);
    }

    @Mod.EventHandler
    public void onIMC(FMLInterModComms.IMCEvent event) {
        SecurityCraftAPI.onIMC(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"cyclicmagic")) {
            MinecraftForge.EVENT_BUS.register((Object)new CyclicCompat());
        }
        for (Field field : SCContent.class.getFields()) {
            try {
                if (!field.isAnnotationPresent(Reinforced.class)) continue;
                IReinforcedBlock.BLOCKS.add((Block)field.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        if (Loader.isModLoaded((String)"projecte") && !Loader.isModLoaded((String)"projecteintegration")) {
            ProjectECompat.registerConversions();
        }
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (tickets, world) -> tickets.forEach(ticket -> {
            if (ticket.getType() == ForgeChunkManager.Type.ENTITY && ((WorldServer)ticket.world).func_175733_a(ticket.getEntity().getPersistentID()) == null) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
        }));
        ConfigHandler.loadEffects();
    }

    public static String getVersion() {
        return Loader.instance().activeModContainer().getVersion();
    }

    static {
        instance = new SecurityCraft();
        tabSCTechnical = new SCTechnicalTab();
        tabSCMine = new SCExplosivesTab();
        tabSCDecoration = new SCDecorationTab();
    }
}

