/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;

public interface ILinkedAction {

    public static final class StateChanged<T extends Comparable<T>>
    implements ILinkedAction {
        public final IProperty<T> property;
        public final T oldValue;
        public final T newValue;

        public StateChanged(IProperty<T> property, T oldValue, T newValue) {
            this.property = property;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }
    }

    public static final class OwnerChanged
    implements ILinkedAction {
        public final Owner newOwner;

        public OwnerChanged(Owner newOwner) {
            this.newOwner = newOwner;
        }
    }

    public static final class ModuleRemoved
    implements ILinkedAction {
        public final ModuleType moduleType;
        public final boolean wasModuleToggled;

        public ModuleRemoved(ModuleType moduleType, boolean wasModuleToggled) {
            this.moduleType = moduleType;
            this.wasModuleToggled = wasModuleToggled;
        }
    }

    public static final class ModuleInserted
    implements ILinkedAction {
        public final ItemStack stack;
        public final ModuleItem module;
        public final boolean wasModuleToggled;

        public ModuleInserted(ItemStack stack, ModuleItem module, boolean wasModuleToggled) {
            this.stack = stack;
            this.module = module;
            this.wasModuleToggled = wasModuleToggled;
        }
    }

    public static final class OptionChanged<T>
    implements ILinkedAction {
        public final Option<T> option;

        public OptionChanged(Option<T> option) {
            this.option = option;
        }
    }
}

