/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public interface IPasswordProtected
extends ICodebreakable {
    default public void openPasswordGUI(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K && this.getPassword() != null) {
            player.openGui((Object)SecurityCraft.instance, 10, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    default public boolean verifyPasswordSet(World world, BlockPos pos, IOwnable ownable, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (this.getPassword() != null) {
                return true;
            }
            if (ownable.isOwnedBy(player)) {
                player.openGui((Object)SecurityCraft.instance, 9, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)new TextComponentString("SecurityCraft"), (ITextComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
            }
        }
        return false;
    }

    @Override
    default public boolean shouldAttemptCodebreak(IBlockState state, EntityPlayer player) {
        if (this.getPassword() == null) {
            PlayerUtils.sendMessageToPlayer(player, (ITextComponent)new TextComponentString("SecurityCraft"), (ITextComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
            return false;
        }
        return true;
    }

    @Override
    default public void useCodebreaker(IBlockState state, EntityPlayer player) {
        this.activate(player);
    }

    public void activate(EntityPlayer var1);

    public String getPassword();

    public void setPassword(String var1);

    public void startCooldown();

    public boolean isOnCooldown();

    public long getCooldownEnd();

    default public void onIncorrectPasscodeEntered(EntityPlayer player, String incorrectCode) {
        if (this instanceof IModuleInventory) {
            IModuleInventory moduleInv = (IModuleInventory)((Object)this);
            if (moduleInv.isModuleEnabled(ModuleType.SMART)) {
                this.startCooldown();
            }
            if (moduleInv.isModuleEnabled(ModuleType.HARMING) && player.func_70097_a(CustomDamageSources.INCORRECT_PASSCODE, (float)ConfigHandler.incorrectPasscodeDamage)) {
                player.func_71053_j();
            }
        }
    }
}

