/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.AlarmBlock;
import net.geforcemods.securitycraft.blocks.OldLitAlarmBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.client.PlayAlarmSound;
import net.geforcemods.securitycraft.util.AlarmSoundHandler;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class AlarmBlockEntity
extends CustomizableBlockEntity
implements ITickable {
    public static final int MAXIMUM_ALARM_SOUND_LENGTH = 3600;
    public Option.IntOption range = new Option.IntOption(() -> ((AlarmBlockEntity)this).func_174877_v(), "range", 17, 0, ConfigHandler.maxAlarmRange, 1, true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.BooleanOption resetCooldown = new Option.BooleanOption("resetCooldown", false);
    private int cooldown = 0;
    private boolean isPowered = false;
    private SoundEvent sound;
    private boolean soundPlaying;
    private int soundLength;

    public AlarmBlockEntity() {
        this.sound = SCSounds.ALARM.event;
        this.soundPlaying = false;
        this.soundLength = 2;
    }

    public void func_73660_a() {
        if (this.func_145838_q() == SCContent.alarmLit) {
            this.field_145850_b.func_175656_a(this.field_174879_c, SCContent.alarm.func_176223_P().func_177226_a((IProperty)AlarmBlock.FACING, this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)OldLitAlarmBlock.FACING)).func_177226_a((IProperty)AlarmBlock.LIT, (Comparable)Boolean.valueOf(false)));
            AlarmBlockEntity newTe = (AlarmBlockEntity)this.field_145850_b.func_175625_s(this.field_174879_c);
            newTe.getOwner().set(this.getOwner().getUUID(), this.getOwner().getName());
            newTe.range.copy(this.range);
            newTe.soundLength = this.soundLength;
            newTe.setPowered(false);
            this.func_145843_s();
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.soundPlaying && (this.isDisabled() || !this.isPowered)) {
                this.stopPlayingSound();
            }
        } else if (!this.isDisabled() && --this.cooldown <= 0) {
            if (this.isPowered) {
                double rangeSqr = Math.pow(((Integer)this.range.get()).intValue(), 2.0);
                SoundEvent soundEvent = this.isModuleEnabled(ModuleType.SMART) ? this.sound : SCSounds.ALARM.event;
                for (EntityPlayerMP player : this.field_145850_b.func_175661_b(EntityPlayerMP.class, p -> p.func_180425_c().func_177951_i((Vec3i)this.field_174879_c) <= rangeSqr)) {
                    float volume = (float)(1.0 - player.func_180425_c().func_177951_i((Vec3i)this.field_174879_c) / rangeSqr);
                    SecurityCraft.network.sendTo((IMessage)new PlayAlarmSound(this.field_174879_c, soundEvent, volume), player);
                }
            }
            this.setCooldown(this.soundLength * 20);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("cooldown", this.cooldown);
        tag.func_74757_a("isPowered", this.isPowered);
        tag.func_74778_a("sound", this.sound.getRegistryName().toString());
        tag.func_74768_a("delay", this.soundLength);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.cooldown = tag.func_74762_e("cooldown");
        this.isPowered = tag.func_74767_n("isPowered");
        if (tag.func_150297_b("sound", 8)) {
            this.setSound(new ResourceLocation(tag.func_74779_i("sound")));
        } else {
            this.setSound(SCSounds.ALARM.location);
        }
        this.soundLength = tag.func_74762_e("delay");
    }

    public void setSound(ResourceLocation soundEvent) {
        this.setSound((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundEvent));
    }

    public void setSound(SoundEvent soundEvent) {
        this.sound = soundEvent;
        this.func_70296_d();
    }

    public SoundEvent getSound() {
        return this.isModuleEnabled(ModuleType.SMART) ? this.sound : SCSounds.ALARM.event;
    }

    public int getSoundLength() {
        return this.soundLength;
    }

    public void setSoundLength(int soundLength) {
        this.soundLength = MathHelper.func_76125_a((int)soundLength, (int)1, (int)3600);
        this.stopPlayingSound();
        this.setCooldown(0);
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setPowered(boolean isPowered) {
        this.isPowered = isPowered;
        if (isPowered && ((Boolean)this.resetCooldown.get()).booleanValue()) {
            this.setCooldown(0);
        }
        this.func_70296_d();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range, this.disabled, this.resetCooldown};
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K && this.soundPlaying) {
            this.stopPlayingSound();
        }
    }

    public void playSound(World level, double x, double y, double z, SoundEvent sound, float volume) {
        AlarmSoundHandler.playSound(this, level, x, y, z, sound, SoundCategory.BLOCKS, volume, 1.0f);
        this.soundPlaying = true;
    }

    public void stopPlayingSound() {
        AlarmSoundHandler.stopCurrentSound(this);
        this.soundPlaying = false;
    }
}

