/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.DisplayCaseBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class DisplayCaseBlockEntity
extends CustomizableBlockEntity
implements ITickable,
IPasswordProtected,
ILockable {
    private AxisAlignedBB renderBoundingBox = Block.field_185505_j;
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption(() -> ((DisplayCaseBlockEntity)this).func_174877_v());
    private long cooldownEnd = 0L;
    private ItemStack displayedStack = ItemStack.field_190927_a;
    private boolean shouldBeOpen;
    private float openness;
    private float oOpenness;
    private String passcode;
    private IBlockState state;

    public void func_174878_a(BlockPos pos) {
        super.func_174878_a(pos);
        this.renderBoundingBox = new AxisAlignedBB(pos);
    }

    public void func_73660_a() {
        this.oOpenness = this.openness;
        if (!this.shouldBeOpen && this.openness > 0.0f) {
            this.openness = Math.max(this.openness - 0.1f, 0.0f);
        } else if (this.shouldBeOpen && this.openness < 1.0f) {
            this.openness = Math.min(this.openness + 0.1f, 1.0f);
        }
    }

    @Override
    public void activate(EntityPlayer player) {
        Block block;
        if (!this.field_145850_b.field_72995_K && (block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()) instanceof DisplayCaseBlock) {
            ((DisplayCaseBlock)block).activate(this);
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(IBlockState state, EntityPlayer player) {
        return !this.isOpen() && IPasswordProtected.super.shouldAttemptCodebreak(state, player);
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
        this.func_70296_d();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("DisplayedStack", (NBTBase)this.getDisplayedStack().func_77955_b(new NBTTagCompound()));
        tag.func_74757_a("ShouldBeOpen", this.shouldBeOpen);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.func_74778_a("Passcode", this.passcode);
        }
        tag.func_74772_a("cooldownLeft", this.getCooldownEnd() - System.currentTimeMillis());
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.load(tag, true);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.load(tag, false);
    }

    public void load(NBTTagCompound tag, boolean forceOpenness) {
        super.func_145839_a(tag);
        this.setDisplayedStack(new ItemStack(tag.func_74775_l("DisplayedStack")));
        this.shouldBeOpen = tag.func_74767_n("ShouldBeOpen");
        this.passcode = tag.func_74779_i("Passcode");
        this.cooldownEnd = System.currentTimeMillis() + tag.func_74763_f("cooldownLeft");
        if (forceOpenness) {
            this.forceOpen(this.shouldBeOpen);
        }
    }

    @Override
    public void startCooldown() {
        if (!this.isOnCooldown()) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.cooldownEnd = System.currentTimeMillis() + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.func_70296_d();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.disabled, this.smartModuleCooldown};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public void setDisplayedStack(ItemStack displayedStack) {
        this.displayedStack = displayedStack;
        this.sync();
    }

    public ItemStack getDisplayedStack() {
        return this.displayedStack;
    }

    public void setOpen(boolean shouldBeOpen) {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, shouldBeOpen ? SCSounds.DISPLAY_CASE_OPEN.event : SCSounds.DISPLAY_CASE_CLOSE.event, SoundCategory.BLOCKS, 1.0f, 1.0f);
        this.shouldBeOpen = shouldBeOpen;
        this.sync();
    }

    public void forceOpen(boolean open) {
        this.shouldBeOpen = open;
        this.openness = open ? 1.0f : 0.0f;
        this.oOpenness = this.openness;
        this.sync();
    }

    public float getOpenness(float partialTicks) {
        return ClientUtils.lerp(partialTicks, this.oOpenness, this.openness);
    }

    public boolean isOpen() {
        return this.shouldBeOpen;
    }

    @Override
    public void sync() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.renderBoundingBox;
    }

    public void setBlockState(IBlockState state) {
        this.state = state;
    }

    public IBlockState getBlockState() {
        if (this.state != null) {
            return this.state;
        }
        if (this.field_145850_b != null) {
            return this.field_145850_b.func_180495_p(this.field_174879_c);
        }
        return SCContent.displayCase.func_176223_P();
    }
}

