/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.KeyPanelBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class KeyPanelBlockEntity
extends CustomizableBlockEntity
implements IPasswordProtected,
ILockable {
    private String passcode;
    private Option.BooleanOption isAlwaysActive = new Option.BooleanOption("isAlwaysActive", false){

        @Override
        public void toggle() {
            super.toggle();
            if (!KeyPanelBlockEntity.this.isDisabled()) {
                KeyPanelBlockEntity.this.field_145850_b.func_175656_a(KeyPanelBlockEntity.this.field_174879_c, KeyPanelBlockEntity.this.field_145850_b.func_180495_p(KeyPanelBlockEntity.this.field_174879_c).func_177226_a((IProperty)KeyPanelBlock.POWERED, (Comparable)this.get()));
                KeyPanelBlockEntity.this.field_145850_b.func_175685_c(KeyPanelBlockEntity.this.field_174879_c, KeyPanelBlockEntity.this.func_145838_q(), false);
            }
        }
    };
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(() -> ((KeyPanelBlockEntity)this).func_174877_v(), "signalLength", 60, 5, 400, 5, true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption(() -> ((KeyPanelBlockEntity)this).func_174877_v());
    private long cooldownEnd = 0L;

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.func_74778_a("passcode", this.passcode);
        }
        tag.func_74772_a("cooldownLeft", this.getCooldownEnd() - System.currentTimeMillis());
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.passcode = tag.func_74779_i("passcode");
        this.cooldownEnd = System.currentTimeMillis() + tag.func_74763_f("cooldownLeft");
    }

    @Override
    public void startCooldown() {
        if (!this.isOnCooldown()) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.cooldownEnd = System.currentTimeMillis() + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.func_70296_d();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.isAlwaysActive, this.sendMessage, this.signalLength, this.disabled, this.smartModuleCooldown};
    }

    @Override
    public void activate(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            ((KeyPanelBlock)this.func_145838_q()).activate(this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b, this.field_174879_c, (Integer)this.signalLength.get());
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(IBlockState state, EntityPlayer player) {
        return (Boolean)state.func_177229_b((IProperty)KeyPanelBlock.POWERED) == false && IPasswordProtected.super.shouldAttemptCodebreak(state, player);
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        if (option.getName().equals("disabled")) {
            boolean isDisabled = (Boolean)((Option.BooleanOption)option).get();
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (isDisabled && ((Boolean)state.func_177229_b((IProperty)KeyPanelBlock.POWERED)).booleanValue()) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)KeyPanelBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            } else if (!isDisabled && ((Boolean)this.isAlwaysActive.get()).booleanValue()) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)KeyPanelBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }
}

