/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.KeycardReaderBlock;
import net.geforcemods.securitycraft.blocks.KeypadBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class KeycardReaderBlockEntity
extends DisguisableBlockEntity
implements ILockable,
ICodebreakable {
    private boolean[] acceptedLevels = new boolean[]{true, false, false, false, false};
    private int signature = 0;
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(() -> ((KeycardReaderBlockEntity)this).func_174877_v(), "signalLength", 60, 5, 400, 5, true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound acceptedLevelsTag = new NBTTagCompound();
        for (int i = 1; i <= 5; ++i) {
            acceptedLevelsTag.func_74757_a("lvl" + i, this.acceptedLevels[i - 1]);
        }
        tag.func_74782_a("acceptedLevels", (NBTBase)acceptedLevelsTag);
        tag.func_74768_a("signature", this.signature);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("passLV")) {
            boolean oldRequiresExactKeycard = false;
            int oldPassLV = tag.func_74762_e("passLV") - 1;
            if (tag.func_74764_b("requiresExactKeycard")) {
                oldRequiresExactKeycard = tag.func_74767_n("requiresExactKeycard");
            }
            for (int i = 0; i < 5; ++i) {
                this.acceptedLevels[i] = oldRequiresExactKeycard ? i == oldPassLV : i >= oldPassLV;
            }
        }
        if (tag.func_150297_b("acceptedLevels", 10)) {
            NBTTagCompound acceptedLevelsTag = tag.func_74775_l("acceptedLevels");
            for (int i = 1; i <= 5; ++i) {
                this.acceptedLevels[i - 1] = acceptedLevelsTag.func_74767_n("lvl" + i);
            }
        }
        this.signature = tag.func_74762_e("signature");
    }

    @Override
    public boolean shouldAttemptCodebreak(IBlockState state, EntityPlayer player) {
        return (Boolean)state.func_177229_b((IProperty)KeypadBlock.POWERED) == false;
    }

    @Override
    public void useCodebreaker(IBlockState state, EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            ((KeycardReaderBlock)this.func_145838_q()).activate(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), (Integer)this.signalLength.get());
        }
    }

    public void setAcceptedLevels(boolean[] acceptedLevels) {
        this.acceptedLevels = acceptedLevels;
    }

    public boolean[] getAcceptedLevels() {
        return this.acceptedLevels;
    }

    public void setSignature(int signature) {
        this.signature = signature;
    }

    public int getSignature() {
        return this.signature;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.DISGUISE, ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength, this.disabled};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }
}

