/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.function.Consumer;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.SpecialDoorBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadBlock;
import net.geforcemods.securitycraft.blocks.KeypadDoorBlock;
import net.geforcemods.securitycraft.blocks.SpecialDoorBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class KeypadDoorBlockEntity
extends SpecialDoorBlockEntity
implements IPasswordProtected {
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption(() -> ((KeypadDoorBlockEntity)this).func_174877_v());
    private long cooldownEnd = 0L;
    private String passcode;

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.func_74778_a("passcode", this.passcode);
        }
        tag.func_74772_a("cooldownLeft", this.getCooldownEnd() - System.currentTimeMillis());
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.passcode = tag.func_74779_i("passcode");
        this.cooldownEnd = System.currentTimeMillis() + tag.func_74763_f("cooldownLeft");
    }

    @Override
    public void activate(EntityPlayer player) {
        IBlockState state;
        if (!this.field_145850_b.field_72995_K && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() instanceof KeypadDoorBlock) {
            if (state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
                this.field_174879_c = this.field_174879_c.func_177977_b();
                state = this.field_145850_b.func_180495_p(this.field_174879_c);
            }
            ((KeypadDoorBlock)state.func_177230_c()).activate(state, this.field_145850_b, this.field_174879_c, this.getSignalLength());
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(IBlockState state, EntityPlayer player) {
        return (Boolean)state.func_177229_b((IProperty)KeypadBlock.POWERED) == false && IPasswordProtected.super.shouldAttemptCodebreak(state, player);
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
        this.runForOtherHalf(otherHalf -> otherHalf.setPasswordExclusively(password));
    }

    public void setPasswordExclusively(String password) {
        this.passcode = password;
    }

    @Override
    public void startCooldown() {
        long start = System.currentTimeMillis();
        this.startCooldown(start);
        this.runForOtherHalf(otherHalf -> otherHalf.startCooldown(start));
    }

    public void startCooldown(long start) {
        if (!this.isOnCooldown()) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.cooldownEnd = start + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.func_70296_d();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength, this.disabled, this.smartModuleCooldown};
    }

    @Override
    public int defaultSignalLength() {
        return 60;
    }

    @Override
    public void setCustomName(String customName) {
        super.setCustomName(customName);
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)SpecialDoorBlock.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
            ((INameSetter)this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())).setCustomName(customName);
        }
    }

    public void runForOtherHalf(Consumer<KeypadDoorBlockEntity> action) {
        TileEntity te = null;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
            te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        } else if (state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        }
        if (te instanceof KeypadDoorBlockEntity) {
            action.accept((KeypadDoorBlockEntity)te);
        }
    }
}

