/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.LaserFieldBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.RefreshDiguisedModel;
import net.geforcemods.securitycraft.util.BlockEntityRenderDelegate;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class LaserBlockBlockEntity
extends LinkableBlockEntity {
    private Option.DisabledOption disabled = new Option.DisabledOption((Boolean)false){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            LaserBlockBlockEntity.this.setLasersAccordingToDisabledOption();
        }
    };
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private EnumMap<EnumFacing, Boolean> sideConfig;

    public LaserBlockBlockEntity() {
        EnumMap<EnumFacing, Boolean> map = new EnumMap<EnumFacing, Boolean>(EnumFacing.class);
        for (EnumFacing dir : EnumFacing.values()) {
            map.put(dir, true);
        }
        this.sideConfig = map;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("sideConfig", (NBTBase)LaserBlockBlockEntity.saveSideConfig(this.sideConfig));
        return tag;
    }

    public static NBTTagCompound saveSideConfig(EnumMap<EnumFacing, Boolean> sideConfig) {
        NBTTagCompound sideConfigTag = new NBTTagCompound();
        sideConfig.forEach((dir, enabled) -> sideConfigTag.func_74757_a(dir.func_176610_l(), enabled.booleanValue()));
        return sideConfigTag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.sideConfig = LaserBlockBlockEntity.loadSideConfig(tag.func_74775_l("sideConfig"));
    }

    public static EnumMap<EnumFacing, Boolean> loadSideConfig(NBTTagCompound sideConfigTag) {
        EnumMap<EnumFacing, Boolean> sideConfig = new EnumMap<EnumFacing, Boolean>(EnumFacing.class);
        for (EnumFacing dir : EnumFacing.values()) {
            if (sideConfigTag.func_150297_b(dir.func_176610_l(), 1)) {
                sideConfig.put(dir, sideConfigTag.func_74767_n(dir.func_176610_l()));
                continue;
            }
            sideConfig.put(dir, true);
        }
        return sideConfig;
    }

    @Override
    protected void onLinkedBlockAction(ILinkedAction action, ArrayList<LinkableBlockEntity> excludedTEs) {
        if (action instanceof ILinkedAction.OptionChanged) {
            Option option = ((ILinkedAction.OptionChanged)action).option;
            if (option.getName().equals("disabled")) {
                this.disabled.copy(option);
                this.setLasersAccordingToDisabledOption();
            } else if (option.getName().equals("ignoreOwner")) {
                this.ignoreOwner.copy(option);
            }
        } else if (action instanceof ILinkedAction.ModuleInserted) {
            ILinkedAction.ModuleInserted moduleInserted = (ILinkedAction.ModuleInserted)action;
            ItemStack module = moduleInserted.stack;
            boolean toggled = moduleInserted.wasModuleToggled;
            this.insertModule(module, toggled);
        } else if (action instanceof ILinkedAction.ModuleRemoved) {
            ILinkedAction.ModuleRemoved moduleRemoved = (ILinkedAction.ModuleRemoved)action;
            ModuleType module = moduleRemoved.moduleType;
            boolean toggled = moduleRemoved.wasModuleToggled;
            this.removeModule(module, toggled);
        } else if (action instanceof ILinkedAction.OwnerChanged) {
            Owner owner = ((ILinkedAction.OwnerChanged)action).newOwner;
            this.setOwner(owner.getUUID(), owner.getName());
        } else if (action instanceof ILinkedAction.StateChanged) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (((ILinkedAction.StateChanged)action).property == LaserBlock.POWERED && !((Boolean)state.func_177229_b((IProperty)LaserBlock.POWERED)).booleanValue()) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)LaserBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, SCContent.laserBlock);
                this.field_145850_b.func_175684_a(this.field_174879_c, SCContent.laserBlock, 50);
            }
        }
        excludedTEs.add(this);
        this.createLinkedBlockAction(action, excludedTEs);
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            this.onInsertDisguiseModule(stack, toggled);
        } else if (module == ModuleType.SMART) {
            this.applyExistingSideConfig();
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            this.onRemoveDisguiseModule(stack, toggled);
        } else if (module == ModuleType.REDSTONE) {
            this.onRemoveRedstoneModule();
        } else if (module == ModuleType.SMART) {
            this.applyExistingSideConfig();
        }
    }

    private void onInsertDisguiseModule(ItemStack stack, boolean toggled) {
        if (!this.field_145850_b.field_72995_K) {
            SecurityCraft.network.sendToAllTracking((IMessage)new RefreshDiguisedModel(this.field_174879_c, true, stack, toggled), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 0.0));
        } else {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            BlockEntityRenderDelegate.putDisguisedTeRenderer(this, stack);
            if (state.getLightValue((IBlockAccess)this.field_145850_b, this.field_174879_c) > 0) {
                this.field_145850_b.func_175664_x(this.field_174879_c);
            }
        }
    }

    private void onRemoveDisguiseModule(ItemStack stack, boolean toggled) {
        if (!this.field_145850_b.field_72995_K) {
            SecurityCraft.network.sendToAllTracking((IMessage)new RefreshDiguisedModel(this.field_174879_c, false, stack, toggled), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 0.0));
        } else {
            IBlockState disguisedState = ((DisguisableBlock)this.field_145854_h).getDisguisedBlockStateFromStack(null, null, stack);
            BlockEntityRenderDelegate.DISGUISED_BLOCK.removeDelegateOf(this);
            if (disguisedState != null && disguisedState.getLightValue((IBlockAccess)this.field_145850_b, this.field_174879_c) > 0) {
                this.field_145850_b.func_175664_x(this.field_174879_c);
            }
        }
    }

    private void onRemoveRedstoneModule() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (((Boolean)state.func_177229_b((IProperty)LaserBlock.POWERED)).booleanValue()) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)LaserBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, SCContent.laserBlock);
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b.field_72995_K) {
            BlockEntityRenderDelegate.putDisguisedTeRenderer(this, this.getModule(ModuleType.DISGUISE));
        }
    }

    @Override
    public void readOptions(NBTTagCompound tag) {
        if (tag.func_74764_b("enabled")) {
            tag.func_74757_a("disabled", !tag.func_74767_n("enabled"));
        }
        for (Option<?> option : this.customOptions()) {
            option.readFromNBT(tag);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            BlockEntityRenderDelegate.DISGUISED_BLOCK.removeDelegateOf(this);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.HARMING, ModuleType.ALLOWLIST, ModuleType.DISGUISE, ModuleType.REDSTONE, ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled, this.ignoreOwner};
    }

    public boolean isEnabled() {
        return (Boolean)this.disabled.get() == false;
    }

    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public void applyNewSideConfig(EnumMap<EnumFacing, Boolean> sideConfig, EntityPlayer player) {
        sideConfig.forEach((direction, enabled) -> this.setSideEnabled((EnumFacing)direction, (boolean)enabled, player));
    }

    public void applyExistingSideConfig() {
        for (EnumFacing direction : EnumFacing.values()) {
            this.toggleLaserOnSide(direction, this.isSideEnabled(direction), null, false);
        }
    }

    public void setSideEnabled(EnumFacing direction, boolean enabled, EntityPlayer player) {
        this.sideConfig.put(direction, enabled);
        if (this.isModuleEnabled(ModuleType.SMART)) {
            this.toggleLaserOnSide(direction, enabled, player, true);
        }
    }

    public void toggleLaserOnSide(EnumFacing direction, boolean enabled, EntityPlayer player, boolean modifyOtherLaser) {
        TileEntity te;
        int i = 1;
        BlockPos pos = this.func_174877_v();
        BlockPos modifiedPos = pos.func_177967_a(direction, i);
        IBlockState ownState = this.field_145850_b.func_180495_p(pos);
        IBlockState stateAtModifiedPos = this.field_145850_b.func_180495_p(modifiedPos);
        while (i < ConfigHandler.laserBlockRange && stateAtModifiedPos.func_177230_c() != SCContent.laserBlock) {
            modifiedPos = pos.func_177967_a(direction, ++i);
            stateAtModifiedPos = this.field_145850_b.func_180495_p(modifiedPos);
        }
        if (modifyOtherLaser && (te = this.field_145850_b.func_175625_s(modifiedPos)) instanceof LaserBlockBlockEntity) {
            ((LaserBlockBlockEntity)te).sideConfig.put(direction.func_176734_d(), enabled);
        }
        if (enabled) {
            Block block = ownState.func_177230_c();
            if (block instanceof LaserBlock) {
                ((LaserBlock)block).setLaser(this.field_145850_b, pos, direction, player);
            }
        } else if (!enabled) {
            int boundType = direction == EnumFacing.UP || direction == EnumFacing.DOWN ? 1 : (direction == EnumFacing.NORTH || direction == EnumFacing.SOUTH ? 2 : 3);
            BlockUtils.removeInSequence((directionToCheck, stateToCheck) -> stateToCheck.func_177230_c() == SCContent.laserField && (Integer)stateToCheck.func_177229_b((IProperty)LaserFieldBlock.BOUNDTYPE) == boundType, this.field_145850_b, pos, direction);
        }
    }

    public EnumMap<EnumFacing, Boolean> getSideConfig() {
        return this.sideConfig;
    }

    public boolean isSideEnabled(EnumFacing dir) {
        return !this.isModuleEnabled(ModuleType.SMART) || this.sideConfig.getOrDefault(dir, true) != false;
    }

    private void setLasersAccordingToDisabledOption() {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (block != SCContent.laserBlock) {
            return;
        }
        if (this.isEnabled()) {
            ((LaserBlock)block).setLaser(this.field_145850_b, this.field_174879_c, null);
        } else {
            LaserBlock.destroyAdjacentLasers(this.field_145850_b, this.field_174879_c);
        }
    }

    public ModuleType synchronizeWith(LaserBlockBlockEntity that) {
        if (!LinkableBlockEntity.isLinkedWith(this, that)) {
            Object2BooleanArrayMap bothInsertedModules = new Object2BooleanArrayMap();
            ArrayList thisInsertedModules = this.getInsertedModules();
            ArrayList thatInsertedModules = that.getInsertedModules();
            for (ModuleType moduleType : thisInsertedModules) {
                ItemStack thisModule = this.getModule(moduleType);
                if (thatInsertedModules.contains((Object)moduleType) && !ItemStack.areItemStackShareTagsEqual((ItemStack)thisModule, (ItemStack)that.getModule(moduleType))) {
                    return moduleType;
                }
                bothInsertedModules.put(thisModule.func_77946_l(), this.isModuleEnabled(moduleType));
                this.removeModule(moduleType, false);
            }
            for (ModuleType moduleType : thatInsertedModules) {
                bothInsertedModules.put(that.getModule(moduleType).func_77946_l(), that.isModuleEnabled(moduleType));
                that.removeModule(moduleType, false);
                this.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleRemoved(moduleType, false), that);
            }
            this.readOptions(that.writeOptions(new NBTTagCompound()));
            LinkableBlockEntity.link(this, that);
            for (Map.Entry entry : bothInsertedModules.entrySet()) {
                ItemStack module = (ItemStack)entry.getKey();
                ModuleItem item = (ModuleItem)module.func_77973_b();
                ModuleType type = item.getModuleType();
                this.insertModule((ItemStack)entry.getKey(), false);
                this.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleInserted(module, item, false), this);
                this.toggleModuleState(type, (Boolean)entry.getValue());
                this.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleInserted(module, item, true), this);
            }
        }
        return null;
    }
}

