/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ReinforcedPistonBlockEntity
extends TileEntity
implements IOwnable,
ITickable {
    private IBlockState pistonState;
    private NBTTagCompound tileEntityTag;
    private EnumFacing pistonFacing;
    private boolean extending;
    private boolean shouldHeadBeRendered;
    private static final ThreadLocal<EnumFacing> MOVING_ENTITY = ThreadLocal.withInitial(() -> null);
    public float progress;
    public float lastProgress;
    private Owner owner = new Owner();

    public ReinforcedPistonBlockEntity() {
    }

    public ReinforcedPistonBlockEntity(IBlockState pistonState, NBTTagCompound tag, EnumFacing pistonFacing, boolean extending, boolean shouldHeadBeRendered) {
        this.pistonState = pistonState;
        this.tileEntityTag = tag;
        this.pistonFacing = pistonFacing;
        this.extending = extending;
        this.shouldHeadBeRendered = shouldHeadBeRendered;
        this.owner = Owner.fromCompound(tag);
    }

    public IBlockState getPistonState() {
        return this.pistonState;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public int func_145832_p() {
        return 0;
    }

    public boolean isExtending() {
        return this.extending;
    }

    public EnumFacing getFacing() {
        return this.pistonFacing;
    }

    public boolean shouldPistonHeadBeRendered() {
        return this.shouldHeadBeRendered;
    }

    public float getProgress(float ticks) {
        if (ticks > 1.0f) {
            ticks = 1.0f;
        }
        return this.lastProgress + (this.progress - this.lastProgress) * ticks;
    }

    public float getOffsetX(float ticks) {
        return (float)this.pistonFacing.func_82601_c() * this.getExtendedProgress(this.getProgress(ticks));
    }

    public float getOffsetY(float ticks) {
        return (float)this.pistonFacing.func_96559_d() * this.getExtendedProgress(this.getProgress(ticks));
    }

    public float getOffsetZ(float ticks) {
        return (float)this.pistonFacing.func_82599_e() * this.getExtendedProgress(this.getProgress(ticks));
    }

    private float getExtendedProgress(float progress) {
        return this.extending ? progress - 1.0f : 1.0f - progress;
    }

    public AxisAlignedBB getAABB(IBlockAccess world, BlockPos pos) {
        return this.getAABB(world, pos, this.progress).func_111270_a(this.getAABB(world, pos, this.lastProgress));
    }

    public AxisAlignedBB getAABB(IBlockAccess world, BlockPos pos, float progress) {
        IBlockState state = this.getCollisionRelatedBlockState();
        progress = this.getExtendedProgress(progress);
        return state.func_185900_c(world, pos).func_72317_d((double)(progress * (float)this.pistonFacing.func_82601_c()), (double)(progress * (float)this.pistonFacing.func_96559_d()), (double)(progress * (float)this.pistonFacing.func_82599_e()));
    }

    private IBlockState getCollisionRelatedBlockState() {
        return !this.isExtending() && this.shouldPistonHeadBeRendered() ? SCContent.reinforcedPistonHead.func_176223_P().func_177226_a((IProperty)BlockPistonExtension.field_176325_b, (Comparable)(this.pistonState.func_177230_c() == SCContent.reinforcedStickyPiston ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT)).func_177226_a((IProperty)BlockPistonExtension.field_176387_N, this.pistonState.func_177229_b((IProperty)BlockPistonBase.field_176387_N)) : this.pistonState;
    }

    private void moveCollidedEntities(float progress) {
        AxisAlignedBB boundingBox;
        List entities;
        EnumFacing facing = this.extending ? this.pistonFacing : this.pistonFacing.func_176734_d();
        double d0 = progress - this.progress;
        ArrayList collisionShape = Lists.newArrayList();
        this.getCollisionRelatedBlockState().func_185908_a(this.field_145850_b, BlockPos.field_177992_a, new AxisAlignedBB(BlockPos.field_177992_a), (List)collisionShape, null, true);
        if (!collisionShape.isEmpty() && !(entities = this.field_145850_b.func_72839_b(null, this.getMovementArea(boundingBox = this.moveByPositionAndProgress(this.getMinMaxPiecesAABB(collisionShape)), facing, d0).func_111270_a(boundingBox))).isEmpty()) {
            boolean isStickyBlock = this.pistonState.func_177230_c().isStickyBlock(this.pistonState);
            for (int i = 0; i < entities.size(); ++i) {
                AxisAlignedBB entityBoundingBox;
                AxisAlignedBB movementArea;
                Entity entity = (Entity)entities.get(i);
                if (entity.func_184192_z() == EnumPushReaction.IGNORE) continue;
                if (isStickyBlock) {
                    switch (facing.func_176740_k()) {
                        case X: {
                            entity.field_70159_w = facing.func_82601_c();
                            break;
                        }
                        case Y: {
                            entity.field_70181_x = facing.func_96559_d();
                            break;
                        }
                        case Z: {
                            entity.field_70179_y = facing.func_82599_e();
                        }
                    }
                }
                double movement = 0.0;
                for (int j = 0; !(j >= collisionShape.size() || (movementArea = this.getMovementArea(this.moveByPositionAndProgress((AxisAlignedBB)collisionShape.get(j)), facing, d0)).func_72326_a(entityBoundingBox = entity.func_174813_aQ()) && (movement = Math.max(movement, this.getMovement(movementArea, facing, entityBoundingBox))) >= d0); ++j) {
                }
                if (!(movement > 0.0)) continue;
                movement = Math.min(movement, d0) + 0.01;
                MOVING_ENTITY.set(facing);
                entity.func_70091_d(MoverType.PISTON, movement * (double)facing.func_82601_c(), movement * (double)facing.func_96559_d(), movement * (double)facing.func_82599_e());
                MOVING_ENTITY.set(null);
                if (this.extending || !this.shouldHeadBeRendered) continue;
                this.fixEntityWithinPistonBase(entity, facing, d0);
            }
        }
    }

    private AxisAlignedBB getMinMaxPiecesAABB(List<AxisAlignedBB> boundingBoxes) {
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 1.0;
        double maxY = 1.0;
        double maxZ = 1.0;
        for (AxisAlignedBB axisalignedbb : boundingBoxes) {
            minX = Math.min(axisalignedbb.field_72340_a, minX);
            minY = Math.min(axisalignedbb.field_72338_b, minY);
            minZ = Math.min(axisalignedbb.field_72339_c, minZ);
            maxX = Math.max(axisalignedbb.field_72336_d, maxX);
            maxY = Math.max(axisalignedbb.field_72337_e, maxY);
            maxZ = Math.max(axisalignedbb.field_72334_f, maxZ);
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private double getMovement(AxisAlignedBB boundingBox, EnumFacing facing, AxisAlignedBB entityBoundingBox) {
        switch (facing.func_176740_k()) {
            case X: {
                return ReinforcedPistonBlockEntity.getDeltaX(boundingBox, facing, entityBoundingBox);
            }
            default: {
                return ReinforcedPistonBlockEntity.getDeltaY(boundingBox, facing, entityBoundingBox);
            }
            case Z: 
        }
        return ReinforcedPistonBlockEntity.getDeltaZ(boundingBox, facing, entityBoundingBox);
    }

    private AxisAlignedBB moveByPositionAndProgress(AxisAlignedBB boundingBox) {
        double progress = this.getExtendedProgress(this.progress);
        return boundingBox.func_72317_d((double)this.field_174879_c.func_177958_n() + progress * (double)this.pistonFacing.func_82601_c(), (double)this.field_174879_c.func_177956_o() + progress * (double)this.pistonFacing.func_96559_d(), (double)this.field_174879_c.func_177952_p() + progress * (double)this.pistonFacing.func_82599_e());
    }

    private AxisAlignedBB getMovementArea(AxisAlignedBB boundingBox, EnumFacing facing, double progress) {
        double d0 = progress * (double)facing.func_176743_c().func_179524_a();
        double d1 = Math.min(d0, 0.0);
        double d2 = Math.max(d0, 0.0);
        switch (facing) {
            case WEST: {
                return new AxisAlignedBB(boundingBox.field_72340_a + d1, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72340_a + d2, boundingBox.field_72337_e, boundingBox.field_72334_f);
            }
            case EAST: {
                return new AxisAlignedBB(boundingBox.field_72336_d + d1, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72336_d + d2, boundingBox.field_72337_e, boundingBox.field_72334_f);
            }
            case DOWN: {
                return new AxisAlignedBB(boundingBox.field_72340_a, boundingBox.field_72338_b + d1, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72338_b + d2, boundingBox.field_72334_f);
            }
            default: {
                return new AxisAlignedBB(boundingBox.field_72340_a, boundingBox.field_72337_e + d1, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72337_e + d2, boundingBox.field_72334_f);
            }
            case NORTH: {
                return new AxisAlignedBB(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c + d1, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c + d2);
            }
            case SOUTH: 
        }
        return new AxisAlignedBB(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f + d1, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f + d2);
    }

    private void fixEntityWithinPistonBase(Entity entity, EnumFacing pushDirection, double progress) {
        double d1;
        EnumFacing facing;
        double d0;
        AxisAlignedBB pistonBoundingBox;
        AxisAlignedBB entityBoundingBox = entity.func_174813_aQ();
        if (entityBoundingBox.func_72326_a(pistonBoundingBox = Block.field_185505_j.func_186670_a(this.field_174879_c)) && Math.abs((d0 = this.getMovement(pistonBoundingBox, facing = pushDirection.func_176734_d(), entityBoundingBox) + 0.01) - (d1 = this.getMovement(pistonBoundingBox, facing, entityBoundingBox.func_191500_a(pistonBoundingBox)) + 0.01)) < 0.01) {
            d0 = Math.min(d0, progress) + 0.01;
            MOVING_ENTITY.set(pushDirection);
            entity.func_70091_d(MoverType.PISTON, d0 * (double)facing.func_82601_c(), d0 * (double)facing.func_96559_d(), d0 * (double)facing.func_82599_e());
            MOVING_ENTITY.set(null);
        }
    }

    private static double getDeltaX(AxisAlignedBB boundingBox, EnumFacing facing, AxisAlignedBB entityBoundingBox) {
        return facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? boundingBox.field_72336_d - entityBoundingBox.field_72340_a : entityBoundingBox.field_72336_d - boundingBox.field_72340_a;
    }

    private static double getDeltaY(AxisAlignedBB boundingBox, EnumFacing facing, AxisAlignedBB entityBoundingBox) {
        return facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? boundingBox.field_72337_e - entityBoundingBox.field_72338_b : entityBoundingBox.field_72337_e - boundingBox.field_72338_b;
    }

    private static double getDeltaZ(AxisAlignedBB boundingBox, EnumFacing facing, AxisAlignedBB entityBoundingBox) {
        return facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? boundingBox.field_72334_f - entityBoundingBox.field_72339_c : entityBoundingBox.field_72334_f - boundingBox.field_72339_c;
    }

    public void clearPistonTileEntity() {
        if (this.lastProgress < 1.0f && this.field_145850_b != null) {
            this.lastProgress = this.progress = 1.0f;
            this.field_145850_b.func_175713_t(this.field_174879_c);
            this.func_145843_s();
            if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == SCContent.reinforcedMovingPiston) {
                IBlockState pushedState = this.getPistonState();
                Block pushedBlock = pushedState.func_177230_c();
                if (this.tileEntityTag != null) {
                    TileEntity te;
                    TileEntity tileEntity = te = pushedBlock.hasTileEntity(pushedState) ? pushedBlock.createTileEntity(this.field_145850_b, pushedState) : null;
                    if (te != null) {
                        Chunk chunk = this.field_145850_b.func_175726_f(this.field_174879_c);
                        te.func_145839_a(this.tileEntityTag);
                        chunk.func_177426_a(this.field_174879_c, te);
                        this.field_145850_b.func_175690_a(this.field_174879_c, te);
                    }
                }
                this.field_145850_b.func_180501_a(this.field_174879_c, pushedState, 3);
                this.field_145850_b.func_190524_a(this.field_174879_c, pushedState.func_177230_c(), this.field_174879_c);
            }
        }
    }

    public void func_73660_a() {
        this.lastProgress = this.progress;
        if (this.lastProgress >= 1.0f) {
            this.field_145850_b.func_175713_t(this.field_174879_c);
            this.func_145843_s();
            if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == SCContent.reinforcedMovingPiston) {
                IBlockState pushedState = this.getPistonState();
                Block pushedBlock = pushedState.func_177230_c();
                if (this.tileEntityTag != null) {
                    TileEntity te;
                    TileEntity tileEntity = te = pushedBlock.hasTileEntity(pushedState) ? pushedBlock.createTileEntity(this.field_145850_b, pushedState) : null;
                    if (te != null) {
                        Chunk chunk = this.field_145850_b.func_175726_f(this.field_174879_c);
                        te.func_145839_a(this.tileEntityTag);
                        chunk.func_177426_a(this.field_174879_c, te);
                        this.field_145850_b.func_175690_a(this.field_174879_c, te);
                    }
                }
                this.field_145850_b.func_180501_a(this.field_174879_c, pushedState, 3);
                this.field_145850_b.func_190524_a(this.field_174879_c, pushedBlock, this.field_174879_c);
            }
        } else {
            float f = this.progress + 0.5f;
            this.moveCollidedEntities(f);
            this.progress = f;
            if (this.progress >= 1.0f) {
                this.progress = 1.0f;
            }
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.pistonState = Block.func_149729_e((int)compound.func_74762_e("blockId")).func_176203_a(compound.func_74762_e("blockData"));
        this.pistonFacing = EnumFacing.func_82600_a((int)compound.func_74762_e("facing"));
        this.lastProgress = this.progress = compound.func_74760_g("progress");
        this.extending = compound.func_74767_n("extending");
        this.shouldHeadBeRendered = compound.func_74767_n("source");
        this.tileEntityTag = compound.func_74775_l("movedTileEntityTag");
        this.owner.readFromNBT(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("blockId", Block.func_149682_b((Block)this.pistonState.func_177230_c()));
        compound.func_74768_a("blockData", this.pistonState.func_177230_c().func_176201_c(this.pistonState));
        compound.func_74768_a("facing", this.pistonFacing.func_176745_a());
        compound.func_74776_a("progress", this.lastProgress);
        compound.func_74757_a("extending", this.extending);
        compound.func_74757_a("source", this.shouldHeadBeRendered);
        compound.func_74782_a("movedTileEntityTag", (NBTBase)this.tileEntityTag);
        if (this.owner != null) {
            this.owner.writeToNBT(compound, false);
        }
        return compound;
    }

    public void addCollisionAABBs(World world, BlockPos pos, AxisAlignedBB entityBoundingBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity) {
        if (!this.extending && this.shouldHeadBeRendered) {
            this.pistonState.func_177226_a((IProperty)BlockPistonBase.field_176320_b, (Comparable)Boolean.valueOf(true)).func_185908_a(world, pos, entityBoundingBox, collidingBoxes, entity, false);
        }
        EnumFacing enumfacing = MOVING_ENTITY.get();
        if ((double)this.progress >= 1.0 || enumfacing != (this.extending ? this.pistonFacing : this.pistonFacing.func_176734_d())) {
            int i = collidingBoxes.size();
            IBlockState state = this.shouldPistonHeadBeRendered() ? SCContent.reinforcedPistonHead.func_176223_P().func_177226_a((IProperty)BlockPistonExtension.field_176387_N, (Comparable)this.pistonFacing).func_177226_a((IProperty)BlockPistonExtension.field_176327_M, (Comparable)Boolean.valueOf(this.extending != 1.0f - this.progress < 0.25f)) : this.pistonState;
            float progress = this.getExtendedProgress(this.progress);
            double d0 = (float)this.pistonFacing.func_82601_c() * progress;
            double d1 = (float)this.pistonFacing.func_96559_d() * progress;
            double d2 = (float)this.pistonFacing.func_82599_e() * progress;
            state.func_185908_a(world, pos, entityBoundingBox.func_72317_d(-d0, -d1, -d2), collidingBoxes, entity, true);
            for (int j = i; j < collidingBoxes.size(); ++j) {
                collidingBoxes.set(j, collidingBoxes.get(j).func_72317_d(d0, d1, d2));
            }
        }
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }
}

