/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import com.google.common.collect.Lists;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToIntFunction;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.RiftStabilizerBlock;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.SyncRiftStabilizer;
import net.geforcemods.securitycraft.util.BlockEntityRenderDelegate;
import net.geforcemods.securitycraft.util.IToggleableEntries;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class RiftStabilizerBlockEntity
extends DisguisableBlockEntity
implements ITickable,
ILockable,
IToggleableEntries<TeleportationType> {
    private final Option.IntOption signalLength = new Option.IntOption(() -> ((RiftStabilizerBlockEntity)this).func_174877_v(), "signalLength", 60, 5, 400, 5, true);
    private final Option.IntOption range = new Option.IntOption(() -> ((RiftStabilizerBlockEntity)this).func_174877_v(), "range", 5, 1, 15, 1, true);
    private final Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private final Map<TeleportationType, Boolean> teleportationFilter = new EnumMap<TeleportationType, Boolean>(TeleportationType.class);
    private double lastTeleportDistance;
    private TeleportationType lastTeleportationType;
    private boolean tracked = false;

    public RiftStabilizerBlockEntity() {
        this.teleportationFilter.put(TeleportationType.CHORUS_FRUIT, true);
        this.teleportationFilter.put(TeleportationType.ENDER_PEARL, true);
        this.teleportationFilter.put(TeleportationType.ENDERMAN, false);
        this.teleportationFilter.put(TeleportationType.SHULKER, false);
        this.teleportationFilter.put(TeleportationType.MODDED, false);
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(RiftStabilizerBlock.HALF) == BlockDoor.EnumDoorHalf.LOWER && !this.tracked) {
            BlockEntityTracker.RIFT_STABILIZER.track(this);
            this.tracked = true;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        BlockEntityTracker.RIFT_STABILIZER.stopTracking(this);
    }

    @Override
    public void setFilter(TeleportationType teleportationType, boolean allowed) {
        if (this.teleportationFilter.containsKey((Object)teleportationType)) {
            RiftStabilizerBlockEntity connectedTileEntity;
            this.teleportationFilter.put(teleportationType, allowed);
            if (this.field_145850_b.field_72995_K) {
                SecurityCraft.network.sendToServer((IMessage)new SyncRiftStabilizer(this.field_174879_c, teleportationType, allowed));
            }
            if ((connectedTileEntity = RiftStabilizerBlock.getConnectedTileEntity(this.field_145850_b, this.field_174879_c)) != null) {
                connectedTileEntity.teleportationFilter.put(teleportationType, allowed);
                if (this.field_145850_b.field_72995_K) {
                    SecurityCraft.network.sendToServer((IMessage)new SyncRiftStabilizer(connectedTileEntity.field_174879_c, teleportationType, allowed));
                }
            }
        }
    }

    @Override
    public boolean getFilter(TeleportationType teleportationType) {
        return this.teleportationFilter.containsKey((Object)teleportationType) && this.teleportationFilter.get((Object)teleportationType) != false;
    }

    @Override
    public String getTypeName(TeleportationType type) {
        return Utils.localize(type.label, new Object[0]).func_150254_d();
    }

    @Override
    public ToIntFunction<TeleportationType> getComparatorOutputFunction() {
        return t -> Lists.newArrayList((Object[])TeleportationType.values()).indexOf(t) + 1;
    }

    @Override
    public Map<TeleportationType, Boolean> getFilters() {
        return this.teleportationFilter;
    }

    @Override
    public TeleportationType getDefaultType() {
        return TeleportationType.MODDED;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound teleportationNBT = new NBTTagCompound();
        int i = 0;
        for (boolean b : this.teleportationFilter.values()) {
            teleportationNBT.func_74757_a("teleportationType" + i, b);
            ++i;
        }
        tag.func_74782_a("teleportationTypes", (NBTBase)teleportationNBT);
        tag.func_74780_a("lastTeleportDistance", this.lastTeleportDistance);
        if (this.lastTeleportationType != null) {
            tag.func_74768_a("lastTeleportationType", Lists.newArrayList((Object[])TeleportationType.values()).indexOf((Object)this.lastTeleportationType));
        }
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_150297_b("teleportationTypes", 10)) {
            NBTTagCompound teleportationNBT = tag.func_74775_l("teleportationTypes");
            int i = 0;
            for (TeleportationType teleportationType : this.teleportationFilter.keySet()) {
                this.teleportationFilter.put(teleportationType, teleportationNBT.func_74767_n("teleportationType" + i));
                ++i;
            }
        }
        this.lastTeleportDistance = tag.func_74769_h("lastTeleportDistance");
        if (tag.func_74764_b("lastTeleportationType")) {
            this.lastTeleportationType = TeleportationType.values()[tag.func_74762_e("lastTeleportationType")];
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        RiftStabilizerBlockEntity connectedTileEntity = RiftStabilizerBlock.getConnectedTileEntity(this.field_145850_b, this.field_174879_c);
        if (connectedTileEntity != null && (toggled ? !connectedTileEntity.isModuleEnabled(module) : !connectedTileEntity.hasModule(module))) {
            connectedTileEntity.insertModule(stack, toggled);
        }
        if (module == ModuleType.DISGUISE) {
            BlockEntityRenderDelegate.putDisguisedTeRenderer(this, stack);
            if (connectedTileEntity != null) {
                BlockEntityRenderDelegate.putDisguisedTeRenderer(connectedTileEntity, stack);
            }
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        RiftStabilizerBlockEntity connectedTileEntity = RiftStabilizerBlock.getConnectedTileEntity(this.field_145850_b, this.field_174879_c);
        if (connectedTileEntity != null && (toggled ? connectedTileEntity.isModuleEnabled(module) : connectedTileEntity.hasModule(module))) {
            connectedTileEntity.removeModule(module, toggled);
        }
        if (module == ModuleType.DISGUISE) {
            BlockEntityRenderDelegate.DISGUISED_BLOCK.removeDelegateOf(this);
            if (connectedTileEntity != null) {
                BlockEntityRenderDelegate.DISGUISED_BLOCK.removeDelegateOf(connectedTileEntity);
            }
        } else if (module == ModuleType.SMART) {
            this.onRemoveSmartModule(this);
            if (connectedTileEntity != null) {
                this.onRemoveSmartModule(connectedTileEntity);
            }
        }
    }

    private void onRemoveSmartModule(RiftStabilizerBlockEntity te) {
        te.teleportationFilter.put(TeleportationType.CHORUS_FRUIT, true);
        te.teleportationFilter.put(TeleportationType.ENDER_PEARL, true);
        te.teleportationFilter.put(TeleportationType.ENDERMAN, false);
        te.teleportationFilter.put(TeleportationType.SHULKER, false);
        te.teleportationFilter.put(TeleportationType.MODDED, false);
    }

    public void setLastTeleport(double teleportDistance, TeleportationType type) {
        this.lastTeleportDistance = teleportDistance;
        this.lastTeleportationType = type;
    }

    public double getLastTeleportDistance() {
        return this.lastTeleportDistance;
    }

    public TeleportationType getLastTeleportationType() {
        return this.lastTeleportationType;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DISGUISE, ModuleType.REDSTONE, ModuleType.HARMING, ModuleType.SMART};
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        RiftStabilizerBlockEntity connectedTileEntity = RiftStabilizerBlock.getConnectedTileEntity(this.field_145850_b, this.field_174879_c);
        if (connectedTileEntity != null) {
            if (option.getName().equals("signalLength")) {
                connectedTileEntity.setSignalLength((Integer)((Option.IntOption)option).get());
            } else if (option.getName().equals("range")) {
                connectedTileEntity.setRange((Integer)((Option.IntOption)option).get());
            } else if (option.getName().equals("disabled")) {
                connectedTileEntity.setDisabled((Boolean)((Option.BooleanOption)option).get());
            } else if (option.getName().equals("ignoreOwner")) {
                connectedTileEntity.setIgnoresOwner((Boolean)((Option.BooleanOption)option).get());
            }
        }
        super.onOptionChanged(option);
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.signalLength, this.range, this.disabled};
    }

    @Override
    public void onOwnerChanged(IBlockState state, World world, BlockPos pos, EntityPlayer player) {
        RiftStabilizerBlockEntity te = RiftStabilizerBlock.getConnectedTileEntity(world, pos);
        if (te != null) {
            te.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
            if (!world.field_72995_K) {
                world.func_73046_m().func_184103_al().func_148540_a((Packet)te.func_189518_D_());
            }
        }
        super.onOwnerChanged(state, world, pos, player);
    }

    public void setSignalLength(int signalLength) {
        if (this.getSignalLength() != signalLength) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.signalLength.setValue(signalLength);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public void setRange(int range) {
        if (this.getRange() != range) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.range.setValue(range);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public int getRange() {
        return (Integer)this.range.get();
    }

    public void setDisabled(boolean disabled) {
        if (this.isDisabled() != disabled) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.disabled.setValue(disabled);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public void setIgnoresOwner(boolean ignoresOwner) {
        if (this.ignoresOwner() != ignoresOwner) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.ignoreOwner.setValue(ignoresOwner);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.func_70296_d();
        }
    }

    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    @Override
    public void setCustomName(String customName) {
        super.setCustomName(customName);
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(RiftStabilizerBlock.HALF) == BlockDoor.EnumDoorHalf.LOWER) {
            ((INameSetter)this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())).setCustomName(customName);
        }
    }

    public static enum TeleportationType {
        CHORUS_FRUIT(Items.field_185161_cS.func_77658_a() + ".name"),
        ENDER_PEARL(Items.field_151079_bi.func_77658_a() + ".name"),
        ENDERMAN("entity." + ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:enderman"))).getName() + ".name"),
        SHULKER("entity." + ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("minecraft:shulker"))).getName() + ".name"),
        MODDED("gui.securitycraft:rift_stabilizer.modded");

        public final String label;

        private TeleportationType(String label) {
            this.label = label;
        }

        public static TeleportationType getTypeFromEvent(EntityLivingBase teleported, Vec3d target) {
            Optional pearl = teleported.field_70170_p.func_175644_a(EntityEnderPearl.class, e -> e.func_174791_d().equals((Object)target)).stream().findFirst();
            if (teleported instanceof EntityEnderman) {
                return ENDERMAN;
            }
            if (teleported instanceof EntityShulker) {
                return SHULKER;
            }
            if (teleported instanceof EntityPlayer && pearl.isPresent()) {
                return ENDER_PEARL;
            }
            return MODDED;
        }
    }
}

