/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.IEMPAffectedBE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.WorldServer;

public class SecurityCameraBlockEntity
extends CustomizableBlockEntity
implements IEMPAffectedBE,
ITickable {
    private final double CAMERA_SPEED = 0.018;
    public double cameraRotation = 0.0;
    public double oCameraRotation = 0.0;
    public boolean addToRotation = true;
    public boolean down = false;
    private boolean shutDown = false;
    private Option.DoubleOption rotationSpeedOption = new Option.DoubleOption(() -> ((SecurityCameraBlockEntity)this).func_174877_v(), "rotationSpeed", 0.018, 0.01, 0.025, 0.001, true);
    private Option.BooleanOption shouldRotateOption = new Option.BooleanOption("shouldRotate", true);
    private Option.DoubleOption customRotationOption = new Option.DoubleOption(() -> ((SecurityCameraBlockEntity)this).func_174877_v(), "customRotation", this.cameraRotation, 1.55, -1.55, (Double)this.rotationSpeedOption.get(), true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private int playersViewing = 0;

    public void func_73660_a() {
        if (!this.shutDown) {
            this.oCameraRotation = this.cameraRotation;
            if (!((Boolean)this.shouldRotateOption.get()).booleanValue()) {
                this.cameraRotation = (Double)this.customRotationOption.get();
                return;
            }
            if (this.addToRotation && this.cameraRotation <= (double)1.55f) {
                this.cameraRotation += ((Double)this.rotationSpeedOption.get()).doubleValue();
            } else {
                this.addToRotation = false;
            }
            if (!this.addToRotation && this.cameraRotation >= (double)-1.55f) {
                this.cameraRotation -= ((Double)this.rotationSpeedOption.get()).doubleValue();
            } else {
                this.addToRotation = true;
            }
        }
    }

    @Override
    public void shutDown() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        IEMPAffectedBE.super.shutDown();
        if (state.func_177230_c() == SCContent.securityCamera && ((Boolean)state.func_177229_b((IProperty)SecurityCameraBlock.POWERED)).booleanValue()) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            this.makeEveryoneStopViewingTheCamera();
        }
    }

    @Override
    public boolean isShutDown() {
        return this.shutDown;
    }

    @Override
    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74757_a("ShutDown", this.shutDown);
        tag.func_74768_a("PlayersViewing", this.playersViewing);
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.shutDown = tag.func_74767_n("ShutDown");
        this.playersViewing = tag.func_74762_e("PlayersViewing");
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            IBlockState newState = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false));
            this.field_145850_b.func_175656_a(this.field_174879_c, newState);
            this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145854_h, false);
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177972_a(((EnumFacing)newState.func_177229_b((IProperty)SecurityCameraBlock.FACING)).func_176734_d()), this.field_145854_h, false);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.REDSTONE, ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.rotationSpeedOption, this.shouldRotateOption, this.customRotationOption, this.disabled};
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof SecurityCameraBlock) {
            this.down = this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)SecurityCameraBlock.FACING) == EnumFacing.DOWN;
        }
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        if (option.getName().equals("disabled") && ((Boolean)((Option.BooleanOption)option).get()).booleanValue()) {
            this.makeEveryoneStopViewingTheCamera();
        }
    }

    private void makeEveryoneStopViewingTheCamera() {
        if (!this.field_145850_b.field_72995_K) {
            for (EntityPlayer p : ((WorldServer)this.field_145850_b).field_73010_i) {
                SecurityCamera camera;
                EntityPlayerMP player = (EntityPlayerMP)p;
                if (!(player.func_175398_C() instanceof SecurityCamera) || !(camera = (SecurityCamera)player.func_175398_C()).func_180425_c().equals((Object)this.field_174879_c)) continue;
                camera.stopViewing(player);
            }
        }
    }

    public void startViewing() {
        ++this.playersViewing;
        this.sync();
    }

    public void stopViewing() {
        --this.playersViewing;
        this.sync();
    }

    public boolean isSomeoneViewing() {
        return this.playersViewing > 0;
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }
}

