/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.UpdateLogger;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class UsernameLoggerBlockEntity
extends DisguisableBlockEntity
implements ITickable,
ILockable {
    private static final int TICKS_BETWEEN_ATTACKS = 80;
    private Option.IntOption searchRadius = new Option.IntOption(() -> ((UsernameLoggerBlockEntity)this).func_174877_v(), "searchRadius", 3, 1, 20, 1, true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    public String[] players = new String[100];
    public String[] uuids = new String[100];
    public long[] timestamps = new long[100];
    private int cooldown = 80;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isDisabled()) {
                return;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            } else if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0) {
                this.field_145850_b.func_175647_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c).func_186662_g((double)((Integer)this.searchRadius.get()).intValue()), e -> !e.func_175149_v()).forEach(this::addPlayer);
                this.syncLoggedPlayersToClient();
                this.cooldown = 80;
            }
        }
    }

    public void addPlayer(EntityPlayer player) {
        String playerName = player.func_70005_c_();
        long timestamp = System.currentTimeMillis();
        if (!(this.isOwnedBy(player) && this.ignoresOwner() || EntityUtils.isInvisible((EntityLivingBase)player) || this.wasPlayerRecentlyAdded(playerName, timestamp))) {
            if (this.isAllowed((Entity)player)) {
                return;
            }
            for (int i = 0; i < this.players.length; ++i) {
                if (this.players[i] != null && !this.players[i].equals("")) continue;
                this.players[i] = player.func_70005_c_();
                this.uuids[i] = player.func_146103_bH().getId().toString();
                this.timestamps[i] = timestamp;
                break;
            }
        }
    }

    private boolean wasPlayerRecentlyAdded(String username, long timestamp) {
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] == null || !this.players[i].equals(username) || this.timestamps[i] + 1000L <= timestamp) continue;
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        for (int i = 0; i < this.players.length; ++i) {
            tag.func_74778_a("player" + i, this.players[i] == null ? "" : this.players[i]);
            tag.func_74778_a("uuid" + i, this.uuids[i] == null ? "" : this.uuids[i]);
            tag.func_74772_a("timestamp" + i, this.timestamps[i]);
        }
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < this.players.length; ++i) {
            this.players[i] = tag.func_74779_i("player" + i);
            this.uuids[i] = tag.func_74779_i("uuid" + i);
            this.timestamps[i] = tag.func_74763_f("timestamp" + i);
        }
    }

    public void syncLoggedPlayersToClient() {
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] == null) continue;
            SecurityCraft.network.sendToAllTracking((IMessage)new UpdateLogger(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), i, this.players[i], this.uuids[i], this.timestamps[i]), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 0.0));
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadius, this.disabled, this.ignoreOwner};
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }
}

