/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.List;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DisguisableBlock
extends OwnableBlock
implements IOverlayDisplay {
    public DisguisableBlock(Material material) {
        super(material);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world, pos);
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.getLightValue(world, pos);
        }
        return super.getLightValue(state, world, pos);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBlockState actualState = this.getDisguisedBlockState((IBlockAccess)world, pos);
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_177230_c().getSoundType(actualState, world, pos, entity);
        }
        return this.field_149762_H;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world, pos);
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185900_c(world, pos);
        }
        return super.func_185496_a(state, world, pos);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world, pos);
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185890_d(world, pos);
        }
        return super.func_180646_a(state, world, pos);
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState((IBlockAccess)world, pos);
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185918_c(world, pos);
        }
        return super.func_180640_a(state, world, pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean isActualState) {
        IBlockState actualState = this.getDisguisedBlockState((IBlockAccess)world, pos);
        if (actualState != null && actualState.func_177230_c() != this) {
            actualState.func_185908_a(world, pos, entityBox, collidingBoxes, entity, true);
        } else {
            DisguisableBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_180646_a(state, (IBlockAccess)world, pos));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IModuleInventory && ((IModuleInventory)te).isModuleEnabled(ModuleType.DISGUISE)) {
            IBlockState disguisedState;
            ItemStack module = ((IModuleInventory)te).getModule(ModuleType.DISGUISE);
            if (!module.func_77942_o()) {
                module.func_77982_d(new NBTTagCompound());
            }
            if ((disguisedState = NBTUtil.func_190008_d((NBTTagCompound)module.func_77978_p().func_74775_l("SavedState"))) != null && disguisedState.func_177230_c() != Blocks.field_150350_a) {
                return disguisedState.func_193401_d(world, pos, face);
            }
            Block block = ((ModuleItem)module.func_77973_b()).getBlockAddon(module.func_77978_p());
            if (block == null) {
                return BlockFaceShape.SOLID;
            }
            return block.func_176223_P().func_193401_d(world, pos, face);
        }
        return BlockFaceShape.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (!(world.func_175625_s(pos) instanceof IModuleInventory)) {
            return true;
        }
        IModuleInventory te = (IModuleInventory)world.func_175625_s(pos);
        if (te.isModuleEnabled(ModuleType.DISGUISE)) {
            Block blockToDisguiseAs;
            IBlockState disguisedState;
            ItemStack disguiseModule = te.getModule(ModuleType.DISGUISE);
            if (!disguiseModule.func_77942_o()) {
                disguiseModule.func_77982_d(new NBTTagCompound());
            }
            if ((disguisedState = NBTUtil.func_190008_d((NBTTagCompound)disguiseModule.func_77978_p().func_74775_l("SavedState"))) != null && disguisedState.func_177230_c() != Blocks.field_150350_a ? !disguisedState.func_185914_p() || !disguisedState.func_185917_h() : (blockToDisguiseAs = ((ModuleItem)disguiseModule.func_77973_b()).getBlockAddon(disguiseModule.func_77978_p())) != null && (!blockToDisguiseAs.func_176223_P().func_185914_p() || !blockToDisguiseAs.func_176223_P().func_185917_h())) {
                return this.checkForSideTransparency(world, world.func_180495_p(pos.func_177972_a(side)), pos.func_177972_a(side), side);
            }
        }
        return true;
    }

    public boolean checkForSideTransparency(IBlockAccess world, IBlockState neighborState, BlockPos neighborPos, EnumFacing side) {
        Block neighborBlock = neighborState.func_177230_c();
        if (neighborBlock.isAir(neighborState, world, neighborPos)) {
            return true;
        }
        return !(neighborBlock instanceof BlockBreakable) || !neighborBlock.getRegistryName().func_110624_b().equals("minecraft");
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState disguisedState = this.getDisguisedBlockState(world, pos);
        return disguisedState != null ? disguisedState : state;
    }

    public static IBlockState getDisguisedBlockStateUnknown(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof DisguisableBlock) {
            return ((DisguisableBlock)state.func_177230_c()).getDisguisedBlockState(world, pos);
        }
        return null;
    }

    public IBlockState getDisguisedBlockState(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IModuleInventory) {
            IModuleInventory te = (IModuleInventory)tile;
            return this.getDisguisedBlockStateFromStack(world, pos, te.isModuleEnabled(ModuleType.DISGUISE) ? te.getModule(ModuleType.DISGUISE) : ItemStack.field_190927_a);
        }
        return null;
    }

    public IBlockState getDisguisedBlockStateFromStack(IBlockAccess world, BlockPos pos, ItemStack module) {
        if (!module.func_190926_b()) {
            IBlockState disguisedState;
            if (!module.func_77942_o()) {
                module.func_77982_d(new NBTTagCompound());
            }
            if ((disguisedState = NBTUtil.func_190008_d((NBTTagCompound)module.func_77978_p().func_74775_l("SavedState"))) != null && disguisedState.func_177230_c() != Blocks.field_150350_a) {
                return disguisedState;
            }
            if (world != null && pos != null) {
                ItemStack disguisedStack = ((ModuleItem)module.func_77973_b()).getAddonAsStack(module.func_77978_p());
                Block block = Block.func_149634_a((Item)disguisedStack.func_77973_b());
                boolean hasMeta = disguisedStack.func_77981_g();
                IBlockState iBlockState = disguisedState = hasMeta ? block.func_176203_a(disguisedStack.func_77952_i()) : block.func_176223_P();
                if (block != this) {
                    return disguisedState.func_185899_b(world, pos);
                }
            }
        }
        return null;
    }

    public ItemStack getDisguisedStack(IBlockAccess world, BlockPos pos) {
        IBlockState disguisedState = this.getDisguisedBlockState(world, pos);
        if (disguisedState != null) {
            return new ItemStack(disguisedState.func_177230_c(), 1, disguisedState.func_177230_c().func_176201_c(disguisedState));
        }
        return new ItemStack((Block)this);
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockAccess)world, pos);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockAccess)world, pos).func_77973_b() == Item.func_150898_a((Block)this);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getDisguisedStack((IBlockAccess)world, pos);
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new DisguisableBlockEntity();
    }
}

