/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.util.AttachFace;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DisplayCaseBlock
extends OwnableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<AttachFace> ATTACH_FACE = PropertyEnum.func_177709_a((String)"attach_face", AttachFace.class);
    public static final AxisAlignedBB FLOOR;
    public static final AxisAlignedBB CEILING;
    public static final AxisAlignedBB WALL_N;
    public static final AxisAlignedBB WALL_E;
    public static final AxisAlignedBB WALL_S;
    public static final AxisAlignedBB WALL_W;

    public DisplayCaseBlock(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(ATTACH_FACE, (Comparable)((Object)AttachFace.WALL)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch ((AttachFace)((Object)state.func_177229_b(ATTACH_FACE))) {
            case FLOOR: {
                return FLOOR;
            }
            case CEILING: {
                return CEILING;
            }
            case WALL: {
                switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                    case NORTH: {
                        return WALL_N;
                    }
                    case EAST: {
                        return WALL_E;
                    }
                    case SOUTH: {
                        return WALL_S;
                    }
                    case WEST: {
                        return WALL_W;
                    }
                }
                return field_185506_k;
            }
        }
        return field_185506_k;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (this.func_176198_a(world, pos, facing)) {
            if (facing.func_176740_k() == EnumFacing.Axis.Y) {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a(ATTACH_FACE, (Comparable)((Object)(facing == EnumFacing.UP ? AttachFace.FLOOR : AttachFace.CEILING)));
            }
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a(ATTACH_FACE, (Comparable)((Object)AttachFace.WALL));
        }
        return null;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return true;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return super.func_176198_a(world, pos, side);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        EnumFacing connectedDirection = this.getConnectedDirection(state);
        if (!this.func_176198_a(world, pos.func_177972_a(connectedDirection.func_176734_d()), connectedDirection)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof DisplayCaseBlockEntity) {
            DisplayCaseBlockEntity be = (DisplayCaseBlockEntity)te;
            ItemStack heldStack = player.func_184586_b(hand);
            if (be.isLocked() && be.disableInteractionWhenLocked(world, pos, player)) {
                TextComponentTranslation blockName = Utils.localize(this.func_149739_a(), new Object[0]);
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)blockName, (ITextComponent)Utils.localize("messages.securitycraft:sonic_security_system.locked", blockName), TextFormatting.DARK_RED, false);
                return true;
            }
            if (be.isOpen()) {
                ItemStack displayedStack = be.getDisplayedStack();
                if (displayedStack.func_190926_b()) {
                    if (!heldStack.func_190926_b()) {
                        ItemStack toAdd;
                        if (player.func_184812_l_()) {
                            toAdd = heldStack.func_77946_l();
                            toAdd.func_190920_e(1);
                        } else {
                            toAdd = heldStack.func_77979_a(1);
                        }
                        be.setDisplayedStack(toAdd);
                        world.func_184133_a(null, pos, SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        return true;
                    }
                } else if (player.func_70093_af()) {
                    player.func_191521_c(displayedStack);
                    world.func_184133_a(null, pos, SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    be.setDisplayedStack(ItemStack.field_190927_a);
                    return true;
                }
                be.setOpen(false);
            } else if (be.isDisabled()) {
                player.func_146105_b((ITextComponent)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.verifyPasswordSet(world, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsMessages()) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize((Block)this, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), TextFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsMessages()) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize((Block)this, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), TextFormatting.GREEN);
                    }
                    this.activate(be);
                } else if (!PlayerUtils.isHoldingItem(player, SCContent.codebreaker, hand)) {
                    be.openPasswordGUI(world, pos, player);
                }
            }
        }
        return true;
    }

    public void activate(DisplayCaseBlockEntity be) {
        be.setOpen(true);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te;
        if (player.func_184812_l_() && (te = world.func_175625_s(pos)) instanceof IModuleInventory) {
            ((IModuleInventory)te).getInventory().clear();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof DisplayCaseBlockEntity) {
            DisplayCaseBlockEntity be = (DisplayCaseBlockEntity)te;
            be.dropAllModules();
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)be.getDisplayedStack());
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Arrays.asList(new ItemStack(SCContent.displayCase));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(SCContent.displayCase);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a(ATTACH_FACE, (Comparable)((Object)(meta >= 8 ? AttachFace.CEILING : (meta >= 4 ? AttachFace.FLOOR : AttachFace.WALL))));
    }

    public int func_176201_c(IBlockState state) {
        AttachFace attachFace = (AttachFace)((Object)state.func_177229_b(ATTACH_FACE));
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + (attachFace == AttachFace.WALL ? 0 : (attachFace == AttachFace.FLOOR ? 4 : 8));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new DisplayCaseBlockEntity();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ATTACH_FACE});
    }

    private EnumFacing getConnectedDirection(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)FACING);
    }

    static {
        float px = 0.0625f;
        FLOOR = new AxisAlignedBB((double)(2.0f * px), (double)(0.0f * px), (double)(2.0f * px), (double)(14.0f * px), (double)(6.0f * px), (double)(14.0f * px));
        CEILING = new AxisAlignedBB((double)(2.0f * px), (double)(10.0f * px), (double)(2.0f * px), (double)(14.0f * px), (double)(16.0f * px), (double)(14.0f * px));
        WALL_N = new AxisAlignedBB((double)(2.0f * px), (double)(2.0f * px), (double)(10.0f * px), (double)(14.0f * px), (double)(14.0f * px), (double)(16.0f * px));
        WALL_E = new AxisAlignedBB((double)(0.0f * px), (double)(2.0f * px), (double)(2.0f * px), (double)(6.0f * px), (double)(14.0f * px), (double)(14.0f * px));
        WALL_S = new AxisAlignedBB((double)(2.0f * px), (double)(2.0f * px), (double)(0.0f * px), (double)(14.0f * px), (double)(14.0f * px), (double)(6.0f * px));
        WALL_W = new AxisAlignedBB((double)(10.0f * px), (double)(2.0f * px), (double)(2.0f * px), (double)(16.0f * px), (double)(14.0f * px), (double)(14.0f * px));
    }
}

