/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.PortableRadarBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PortableRadarBlock
extends OwnableBlock {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    private static final AxisAlignedBB UP_AABB = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.45f, (double)0.7f);
    private static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB((double)0.3f, (double)0.55f, (double)0.3f, (double)0.7f, 1.0, (double)0.7f);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, (double)0.3f, (double)0.3f, (double)0.45f, (double)0.7f, (double)0.7f);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB((double)0.55f, (double)0.3f, (double)0.3f, 1.0, (double)0.7f, (double)0.7f);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB((double)0.3f, (double)0.3f, (double)0.55f, (double)0.7f, (double)0.7f, 1.0);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB((double)0.3f, (double)0.3f, 0.0, (double)0.7f, (double)0.7f, (double)0.45f);

    public PortableRadarBlock(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case UP: {
                return UP_AABB;
            }
            case DOWN: {
                return DOWN_AABB;
            }
        }
        return field_185505_j;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.func_176198_a(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            world.func_175655_b(pos, true);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te;
        if (player.func_184812_l_() && (te = world.func_175625_s(pos)) instanceof IModuleInventory) {
            ((IModuleInventory)te).getInventory().clear();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IModuleInventory) {
            ((IModuleInventory)te).dropAllModules();
        }
        super.func_180663_b(world, pos, state);
    }

    public static void togglePowerOutput(World world, BlockPos pos, boolean shouldPower) {
        IBlockState state = world.func_180495_p(pos);
        boolean powered = (Boolean)state.func_177229_b((IProperty)POWERED);
        if (shouldPower && !powered) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
            BlockUtils.updateIndirectNeighbors(world, pos, SCContent.portableRadar, (EnumFacing)state.func_177229_b((IProperty)FACING));
        } else if (!shouldPower && powered) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(world, pos, SCContent.portableRadar, (EnumFacing)state.func_177229_b((IProperty)FACING));
        }
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && ((IModuleInventory)world.func_175625_s(pos)).isModuleEnabled(ModuleType.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false && ((IModuleInventory)world.func_175625_s(pos)).isModuleEnabled(ModuleType.REDSTONE) && state.func_177229_b((IProperty)FACING) == side ? 15 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        boolean powered = meta % 2 == 1;
        EnumFacing facing = EnumFacing.UP;
        if (powered) {
            --meta;
        }
        switch (meta) {
            case 2: {
                facing = EnumFacing.DOWN;
                break;
            }
            case 4: {
                facing = EnumFacing.NORTH;
                break;
            }
            case 6: {
                facing = EnumFacing.SOUTH;
                break;
            }
            case 8: {
                facing = EnumFacing.WEST;
                break;
            }
            case 10: {
                facing = EnumFacing.EAST;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered)).func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case UP: {
                meta = 0;
                break;
            }
            case DOWN: {
                meta = 2;
                break;
            }
            case NORTH: {
                meta = 4;
                break;
            }
            case SOUTH: {
                meta = 6;
                break;
            }
            case WEST: {
                meta = 8;
                break;
            }
            case EAST: {
                meta = 10;
            }
        }
        return meta + ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 1 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED, FACING});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.func_176740_k() != EnumFacing.Axis.Z) break;
                return state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
            }
            case FRONT_BACK: {
                if (facing.func_176740_k() != EnumFacing.Axis.X) break;
                return state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
            }
        }
        return state;
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new PortableRadarBlockEntity();
    }
}

