/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SecurityCameraBlock
extends OwnableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public SecurityCameraBlock(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess access, BlockPos pos) {
        return null;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        if (state.func_177229_b((IProperty)FACING) == EnumFacing.DOWN) {
            return EnumBlockRenderType.MODEL;
        }
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity te;
        if (player.func_184812_l_() && (te = world.func_175625_s(pos)) instanceof IModuleInventory) {
            ((IModuleInventory)te).getInventory().clear();
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IModuleInventory) {
            ((IModuleInventory)te).dropAllModules();
        }
        super.func_180663_b(world, pos, state);
        world.func_175685_c(pos.func_177978_c(), world.func_180495_p(pos).func_177230_c(), true);
        world.func_175685_c(pos.func_177968_d(), world.func_180495_p(pos).func_177230_c(), true);
        world.func_175685_c(pos.func_177974_f(), world.func_180495_p(pos).func_177230_c(), true);
        world.func_175685_c(pos.func_177976_e(), world.func_180495_p(pos).func_177230_c(), true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)FACING);
        float px = 0.0625f;
        if (dir == EnumFacing.SOUTH) {
            return new AxisAlignedBB((double)0.275f, 0.25, 0.0, (double)0.7f, (double)0.8f, (double)0.85f);
        }
        if (dir == EnumFacing.NORTH) {
            return new AxisAlignedBB((double)0.275f, 0.25, (double)0.15f, (double)0.7f, (double)0.8f, 1.0);
        }
        if (dir == EnumFacing.WEST) {
            return new AxisAlignedBB(0.125, 0.25, (double)0.275f, 1.0, (double)0.8f, (double)0.725f);
        }
        if (dir == EnumFacing.DOWN) {
            return new AxisAlignedBB((double)(px * 5.0f), (double)(1.0f - px * 2.0f), (double)(px * 5.0f), (double)(px * 11.0f), 1.0, (double)(px * 11.0f));
        }
        return new AxisAlignedBB(0.0, 0.25, (double)0.275f, (double)0.85f, (double)0.8f, (double)0.725f);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        if (!world.isSideSolid(pos.func_177972_a(facing.func_176734_d()), facing)) {
            for (EnumFacing newFacing : EnumFacing.Plane.HORIZONTAL) {
                if (!world.isSideSolid(pos.func_177972_a(newFacing.func_176734_d()), newFacing)) continue;
                state = state.func_177226_a((IProperty)FACING, (Comparable)newFacing);
                break;
            }
        }
        return state;
    }

    public void mountCamera(World world, int x, int y, int z, EntityPlayer player) {
        if (!world.field_72995_K) {
            int cz;
            int cx;
            EntityPlayerMP serverPlayer = (EntityPlayerMP)player;
            WorldServer serverWorld = (WorldServer)world;
            BlockPos pos = new BlockPos(x, y, z);
            Chunk chunk = serverWorld.func_175726_f(pos);
            ChunkPos chunkPos = chunk.func_76632_l();
            int viewDistance = serverPlayer.field_71133_b.func_184103_al().func_72395_o();
            TileEntity te = world.func_175625_s(pos);
            ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)SecurityCraft.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
            SecurityCamera dummyEntity = serverPlayer.func_175398_C() instanceof SecurityCamera ? new SecurityCamera(world, x, y, z, (SecurityCamera)serverPlayer.func_175398_C()) : new SecurityCamera(world, x, y, z);
            ticket.bindEntity((Entity)dummyEntity);
            dummyEntity.setChunkTicket(ticket);
            for (cx = chunkPos.field_77276_a - viewDistance; cx <= chunkPos.field_77276_a + viewDistance; ++cx) {
                for (cz = chunkPos.field_77275_b - viewDistance; cz <= chunkPos.field_77275_b + viewDistance; ++cz) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)new ChunkPos(cx, cz));
                }
            }
            for (cx = chunkPos.field_77276_a - viewDistance; cx <= chunkPos.field_77276_a + viewDistance; ++cx) {
                for (cz = chunkPos.field_77275_b - viewDistance; cz <= chunkPos.field_77275_b + viewDistance; ++cz) {
                    serverWorld.func_184164_w().func_187302_c(cx, cz).func_187276_a(serverPlayer);
                }
            }
            world.func_72838_d((Entity)dummyEntity);
            serverPlayer.field_175401_bS = dummyEntity;
            SecurityCraft.network.sendTo((IMessage)new SetCameraView(dummyEntity), serverPlayer);
            for (EntityTrackerEntry entry : serverWorld.func_73039_n().field_72793_b) {
                entry.func_73117_b(serverPlayer);
            }
            if (te instanceof SecurityCameraBlockEntity) {
                ((SecurityCameraBlockEntity)te).startViewing();
            }
        }
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP) {
            return false;
        }
        return world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && ((IModuleInventory)world.func_175625_s(pos)).isModuleEnabled(ModuleType.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && ((IModuleInventory)world.func_175625_s(pos)).isModuleEnabled(ModuleType.REDSTONE) && state.func_177229_b((IProperty)FACING) == side) {
            return 15;
        }
        return 0;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.func_176196_c(world, pos) && !this.func_176198_a(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public IBlockState func_176203_a(int meta) {
        if (meta <= 5) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(EnumFacing.values()[meta] == EnumFacing.UP ? EnumFacing.NORTH : EnumFacing.values()[meta])).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.values()[meta - 6]).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true));
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() + 6;
        }
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    @Override
    public TileEntity func_149915_a(World world, int meta) {
        return new SecurityCameraBlockEntity();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.func_176740_k() != EnumFacing.Axis.Z) break;
                return state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
            }
            case FRONT_BACK: {
                if (facing.func_176740_k() != EnumFacing.Axis.X) break;
                return state.func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
            }
        }
        return state;
    }
}

