/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ExplosiveBlock
extends OwnableBlock
implements IExplosive {
    public ExplosiveBlock(Material material) {
        super(material);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (PlayerUtils.isHoldingItem(player, SCContent.remoteAccessMine, hand) || PlayerUtils.isHoldingItem(player, SCContent.universalOwnerChanger, hand)) {
            return false;
        }
        if (this.isActive(world, pos) && this.isDefusable() && PlayerUtils.isHoldingItem(player, SCContent.wireCutters, hand)) {
            if (this.defuseMine(world, pos)) {
                if (!player.func_184812_l_()) {
                    player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        if (!this.isActive(world, pos) && PlayerUtils.isHoldingItem(player, Items.field_151033_d, hand)) {
            if (this.activateMine(world, pos)) {
                if (!player.func_184812_l_()) {
                    player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187907_gg, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        if (this.explodesWhenInteractedWith() && this.isActive(world, pos) && !EntityUtils.doesPlayerOwn(player, world, pos)) {
            this.explode(world, pos);
            return true;
        }
        return false;
    }

    public boolean explodesWhenInteractedWith() {
        return true;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }
}

