/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedHopperBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedPistonBlockEntity;
import net.geforcemods.securitycraft.blockentities.ValidationOwnableBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedMovingPistonBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.ReinforcedPistonBlockStructureHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ReinforcedPistonBlock
extends BlockPistonBase
implements IReinforcedBlock,
ITileEntityProvider {
    public ReinforcedPistonBlock(boolean isSticky) {
        super(isSticky);
    }

    public float func_149638_a(Entity exploder) {
        return Float.MAX_VALUE;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void func_176316_e(World world, BlockPos pos, IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_176387_N);
        boolean hasSignal = this.shouldBeExtended(world, pos, facing);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof OwnableBlockEntity && !((OwnableBlockEntity)te).getOwner().isValidated()) {
            return;
        }
        if (hasSignal && !((Boolean)state.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
            if (new ReinforcedPistonBlockStructureHelper(world, pos, facing, true).canMove()) {
                world.func_175641_c(pos, (Block)this, 0, facing.func_176745_a());
            }
        } else if (!hasSignal && ((Boolean)state.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
            world.func_175641_c(pos, (Block)this, 1, facing.func_176745_a());
        }
    }

    private boolean shouldBeExtended(World world, BlockPos pos, EnumFacing facing) {
        for (EnumFacing dir : EnumFacing.values()) {
            if (dir == facing || !world.func_175709_b(pos.func_177972_a(dir), dir)) continue;
            return true;
        }
        if (world.func_175709_b(pos, EnumFacing.DOWN)) {
            return true;
        }
        BlockPos posAbove = pos.func_177984_a();
        for (EnumFacing dir : EnumFacing.values()) {
            if (dir == EnumFacing.DOWN || !world.func_175709_b(posAbove.func_177972_a(dir), dir)) continue;
            return true;
        }
        return false;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_176387_N);
        if (!world.field_72995_K) {
            boolean isPowered = this.shouldBeExtended(world, pos, facing);
            if (isPowered && id == 1) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)field_176320_b, (Comparable)Boolean.valueOf(true)), 2);
                return false;
            }
            if (!isPowered && id == 0) {
                return false;
            }
        }
        if (id == 0) {
            if (!this.doMove(world, pos, facing, true)) {
                return false;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)field_176320_b, (Comparable)Boolean.valueOf(true)), 3);
            world.func_184133_a(null, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f);
        } else if (id == 1) {
            TileEntity tePiston = world.func_175625_s(pos.func_177972_a(facing));
            if (tePiston instanceof ReinforcedPistonBlockEntity) {
                ((ReinforcedPistonBlockEntity)tePiston).clearPistonTileEntity();
            }
            TileEntity te = world.func_175625_s(pos);
            world.func_180501_a(pos, SCContent.reinforcedMovingPiston.func_176223_P().func_177226_a((IProperty)BlockPistonMoving.field_176426_a, (Comparable)facing).func_177226_a((IProperty)BlockPistonMoving.field_176425_b, (Comparable)(this.field_150082_a ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT)), 3);
            world.func_175690_a(pos, ReinforcedMovingPistonBlock.createTilePiston(this.func_176203_a(param), te != null ? te.func_189517_E_() : null, facing, false, true));
            if (this.field_150082_a) {
                ReinforcedPistonBlockEntity offsetTePiston;
                TileEntity offsetTe;
                BlockPos offsetPos = pos.func_177982_a(facing.func_82601_c() * 2, facing.func_96559_d() * 2, facing.func_82599_e() * 2);
                IBlockState offsetState = world.func_180495_p(offsetPos);
                Block offsetBlock = offsetState.func_177230_c();
                boolean flag = false;
                if (offsetBlock == SCContent.reinforcedMovingPiston && (offsetTe = world.func_175625_s(offsetPos)) instanceof ReinforcedPistonBlockEntity && (offsetTePiston = (ReinforcedPistonBlockEntity)offsetTe).getFacing() == facing && offsetTePiston.isExtending()) {
                    offsetTePiston.clearPistonTileEntity();
                    flag = true;
                }
                if (!(flag || offsetState.func_177230_c().isAir(offsetState, (IBlockAccess)world, offsetPos) || !ReinforcedPistonBlock.canPush(offsetState, world, pos, offsetPos, facing.func_176734_d(), false, facing) || offsetState.func_185905_o() != EnumPushReaction.NORMAL && offsetBlock != SCContent.reinforcedPiston && offsetBlock != SCContent.reinforcedStickyPiston)) {
                    this.doMove(world, pos, facing, false);
                }
            } else {
                world.func_175698_g(pos.func_177972_a(facing));
            }
            world.func_184133_a(null, pos, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.15f + 0.6f);
        }
        return true;
    }

    public static boolean canPush(IBlockState state, World world, BlockPos pistonPos, BlockPos pos, EnumFacing facing, boolean destroyBlocks, EnumFacing direction) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150343_Z || block == SCContent.reinforcedObsidian) {
            return false;
        }
        if (!world.func_175723_af().func_177746_a(pos)) {
            return false;
        }
        if (!(pos.func_177956_o() < 0 || facing == EnumFacing.DOWN && pos.func_177956_o() == 0 || pos.func_177956_o() > world.func_72800_K() - 1 || facing == EnumFacing.UP && pos.func_177956_o() == world.func_72800_K() - 1)) {
            if (block != Blocks.field_150331_J && block != Blocks.field_150320_F && block != SCContent.reinforcedPiston && block != SCContent.reinforcedStickyPiston) {
                if (state.func_177230_c() instanceof IReinforcedBlock ? !ReinforcedPistonBlock.isSameOwner(pos, pistonPos, world) : state.func_185887_b(world, pos) == -1.0f) {
                    return false;
                }
                switch (state.func_185905_o()) {
                    case BLOCK: {
                        return false;
                    }
                    case DESTROY: {
                        return destroyBlocks;
                    }
                    case PUSH_ONLY: {
                        return facing == direction;
                    }
                }
            } else if (((Boolean)state.func_177229_b((IProperty)field_176320_b)).booleanValue()) {
                return false;
            }
            return !block.hasTileEntity(state) || state.func_177230_c() instanceof IReinforcedBlock;
        }
        return false;
    }

    private boolean doMove(World world, BlockPos pos, EnumFacing facing, boolean extending) {
        ReinforcedPistonBlockStructureHelper structureHelper;
        if (!extending) {
            world.func_175698_g(pos.func_177972_a(facing));
        }
        if (!(structureHelper = new ReinforcedPistonBlockStructureHelper(world, pos, facing, extending)).canMove()) {
            return false;
        }
        List<BlockPos> blocksToMove = structureHelper.getBlocksToMove();
        ArrayList statesToMove = Lists.newArrayList();
        for (int i = 0; i < blocksToMove.size(); ++i) {
            BlockPos posToMove = blocksToMove.get(i);
            statesToMove.add(world.func_180495_p(posToMove).func_185899_b((IBlockAccess)world, posToMove));
        }
        List<BlockPos> blocksToDestroy = structureHelper.getBlocksToDestroy();
        int k = blocksToMove.size() + blocksToDestroy.size();
        IBlockState[] updatedBlocks = new IBlockState[k];
        EnumFacing direction = extending ? facing : facing.func_176734_d();
        for (int j = blocksToDestroy.size() - 1; j >= 0; --j) {
            BlockPos posToDestroy = blocksToDestroy.get(j);
            IBlockState stateToDestroy = world.func_180495_p(posToDestroy);
            float chance = stateToDestroy.func_177230_c() instanceof BlockSnow ? -1.0f : 1.0f;
            stateToDestroy.func_177230_c().func_180653_a(world, posToDestroy, stateToDestroy, chance, 0);
            world.func_180501_a(posToDestroy, Blocks.field_150350_a.func_176223_P(), 4);
            updatedBlocks[--k] = stateToDestroy;
        }
        for (int l = blocksToMove.size() - 1; l >= 0; --l) {
            BlockPos posToMove = blocksToMove.get(l);
            IBlockState stateToMove = world.func_180495_p(posToMove);
            TileEntity teToMove = world.func_175625_s(posToMove);
            NBTTagCompound tag = null;
            if (teToMove != null) {
                tag = new NBTTagCompound();
                teToMove.func_174878_a(posToMove.func_177972_a(direction));
                teToMove.func_189515_b(tag);
                if (teToMove instanceof ReinforcedHopperBlockEntity) {
                    tag.func_82580_o("Items");
                }
            }
            world.func_180501_a(posToMove, Blocks.field_150350_a.func_176223_P(), 2);
            posToMove = posToMove.func_177972_a(direction);
            world.func_180501_a(posToMove, SCContent.reinforcedMovingPiston.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)facing), 4);
            world.func_175690_a(posToMove, ReinforcedMovingPistonBlock.createTilePiston((IBlockState)statesToMove.get(l), tag, facing, extending, false));
            updatedBlocks[--k] = stateToMove;
        }
        BlockPos frontPos = pos.func_177972_a(facing);
        TileEntity pistonTe = world.func_175625_s(pos);
        if (extending) {
            BlockPistonExtension.EnumPistonType type = this.field_150082_a ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT;
            IBlockState pistonHead = SCContent.reinforcedPistonHead.func_176223_P().func_177226_a((IProperty)BlockPistonExtension.field_176387_N, (Comparable)facing).func_177226_a((IProperty)BlockPistonExtension.field_176325_b, (Comparable)type);
            IBlockState pistonExtension = SCContent.reinforcedMovingPiston.func_176223_P().func_177226_a((IProperty)BlockPistonMoving.field_176426_a, (Comparable)facing).func_177226_a((IProperty)BlockPistonMoving.field_176425_b, (Comparable)(this.field_150082_a ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT));
            OwnableBlockEntity headTe = new OwnableBlockEntity();
            if (pistonTe instanceof OwnableBlockEntity) {
                headTe.setOwner(((OwnableBlockEntity)pistonTe).getOwner().getUUID(), ((OwnableBlockEntity)pistonTe).getOwner().getName());
            }
            world.func_180501_a(frontPos, pistonExtension, 4);
            world.func_175690_a(frontPos, ReinforcedMovingPistonBlock.createTilePiston(pistonHead, headTe.func_189517_E_(), facing, true, true));
        }
        for (int i1 = blocksToDestroy.size() - 1; i1 >= 0; --i1) {
            world.func_175685_c(blocksToDestroy.get(i1), updatedBlocks[k++].func_177230_c(), false);
        }
        for (int j1 = blocksToMove.size() - 1; j1 >= 0; --j1) {
            world.func_175685_c(blocksToMove.get(j1), updatedBlocks[k++].func_177230_c(), false);
        }
        if (extending) {
            world.func_175685_c(frontPos, SCContent.reinforcedPistonHead, false);
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new ValidationOwnableBlockEntity();
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return Arrays.asList(this.field_150082_a ? Blocks.field_150320_F : Blocks.field_150331_J);
    }

    @Override
    public int getAmount() {
        return 0;
    }

    private static boolean isSameOwner(BlockPos blockPos, BlockPos pistonPos, World world) {
        TileEntity pistonTE = world.func_175625_s(pistonPos);
        IOwnable blockTE = (IOwnable)world.func_175625_s(blockPos);
        if (pistonTE instanceof IOwnable) {
            return blockTE.getOwner().owns((IOwnable)pistonTE);
        }
        return false;
    }
}

