/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.top;

import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blockentities.KeycardReaderBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.FakeLavaBaseBlock;
import net.geforcemods.securitycraft.blocks.FakeWaterBaseBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class TOPDataProvider
implements Function<ITheOneProbe, Void> {
    private final String formatting = TextFormatting.BLUE.toString() + TextFormatting.ITALIC.toString();

    @Override
    @Nullable
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerBlockDisplayOverride((mode, probeInfo, player, world, blockState, data) -> {
            ItemStack displayStack;
            boolean edited = false;
            ItemStack item = ItemStack.field_190927_a;
            ItemStack itemLabel = ItemStack.field_190927_a;
            String labelText = "";
            String text = this.formatting + "Minecraft";
            if (blockState.func_177230_c() instanceof DisguisableBlock) {
                itemLabel = item = ((DisguisableBlock)blockState.func_177230_c()).getDisguisedStack((IBlockAccess)world, data.getPos());
                text = this.formatting + ((ModContainer)Loader.instance().getIndexedModList().get(item.func_77973_b().getRegistryName().func_110624_b())).getName();
                edited = true;
            } else if (blockState.func_177230_c() instanceof FakeLavaBaseBlock) {
                item = new ItemStack(Items.field_151129_at);
                labelText = Utils.localize("tile.lava.name", new Object[0]).func_150254_d();
                edited = true;
            } else if (blockState.func_177230_c() instanceof FakeWaterBaseBlock) {
                item = new ItemStack(Items.field_151131_as);
                labelText = Utils.localize("tile.water.name", new Object[0]).func_150254_d();
                edited = true;
            } else if (blockState.func_177230_c() instanceof IOverlayDisplay && (displayStack = ((IOverlayDisplay)blockState.func_177230_c()).getDisplayStack(world, blockState, data.getPos())) != null) {
                item = itemLabel = displayStack;
                edited = true;
            }
            if (edited) {
                IProbeInfo info = probeInfo.horizontal().item(item).vertical();
                if (itemLabel.func_190926_b()) {
                    info.text(labelText);
                } else {
                    info.itemLabel(itemLabel);
                }
                info.text(text);
                return true;
            }
            return false;
        });
        theOneProbe.registerProvider(new IProbeInfoProvider(){

            public String getID() {
                return "securitycraft:securitycraft";
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
                Block block = blockState.func_177230_c();
                if (block instanceof IOverlayDisplay && !((IOverlayDisplay)block).shouldShowSCInfo(world, blockState, data.getPos())) {
                    return;
                }
                TileEntity te = world.func_175625_s(data.getPos());
                if (te instanceof IOwnable) {
                    probeInfo.vertical().text(TextFormatting.GRAY + Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(((IOwnable)te).getOwner())).func_150254_d());
                }
                if (te instanceof IModuleInventory && (!(te instanceof IOwnable) || ((IOwnable)te).isOwnedBy(player)) && !((IModuleInventory)te).getInsertedModules().isEmpty()) {
                    probeInfo.text(TextFormatting.GRAY + Utils.localize("waila.securitycraft:equipped", new Object[0]).func_150254_d());
                    for (ModuleType module : ((IModuleInventory)te).getInsertedModules()) {
                        probeInfo.text(TextFormatting.GRAY + "- " + Utils.localize(module.getTranslationKey(), new Object[0]).func_150254_d());
                    }
                }
                if (te instanceof IPasswordProtected && !(te instanceof KeycardReaderBlockEntity) && ((IOwnable)te).isOwnedBy(player)) {
                    String password = ((IPasswordProtected)te).getPassword();
                    probeInfo.text(TextFormatting.GRAY + Utils.localize("waila.securitycraft:password", new Object[0]).func_150254_d() + TextFormatting.GRAY + " " + (password != null && !password.isEmpty() ? password : Utils.localize("waila.securitycraft:password.notSet", new Object[0]).func_150254_d()));
                }
                if (te instanceof IWorldNameable && ((IWorldNameable)te).func_145818_k_()) {
                    String name = ((IWorldNameable)te).func_70005_c_();
                    probeInfo.text(TextFormatting.GRAY + Utils.localize("waila.securitycraft:customName", new Object[0]).func_150254_d() + " " + name);
                }
            }
        });
        theOneProbe.registerEntityProvider(new IProbeInfoEntityProvider(){

            public String getID() {
                return "securitycraft:securitycraft";
            }

            public void addProbeEntityInfo(ProbeMode probeMode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
                if (entity instanceof Sentry) {
                    Sentry sentry = (Sentry)entity;
                    Sentry.EnumSentryMode mode = sentry.getMode();
                    probeInfo.text(TextFormatting.GRAY + Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(sentry.getOwner())).func_150254_d());
                    if (!sentry.getAllowlistModule().func_190926_b() || !sentry.getDisguiseModule().func_190926_b() || sentry.hasSpeedModule()) {
                        probeInfo.text(TextFormatting.GRAY + Utils.localize("waila.securitycraft:equipped", new Object[0]).func_150254_d());
                        if (!sentry.getAllowlistModule().func_190926_b()) {
                            probeInfo.text(TextFormatting.GRAY + "- " + Utils.localize(ModuleType.ALLOWLIST.getTranslationKey(), new Object[0]).func_150254_d());
                        }
                        if (!sentry.getDisguiseModule().func_190926_b()) {
                            probeInfo.text(TextFormatting.GRAY + "- " + Utils.localize(ModuleType.DISGUISE.getTranslationKey(), new Object[0]).func_150254_d());
                        }
                        if (sentry.hasSpeedModule()) {
                            probeInfo.text(TextFormatting.GRAY + "- " + Utils.localize(ModuleType.SPEED.getTranslationKey(), new Object[0]).func_150254_d());
                        }
                    }
                    String modeDescription = Utils.localize(mode.getModeKey(), new Object[0]).func_150254_d();
                    if (mode != Sentry.EnumSentryMode.IDLE) {
                        modeDescription = modeDescription + " - " + Utils.localize(mode.getTargetKey(), new Object[0]).func_150254_d();
                    }
                    probeInfo.text(TextFormatting.GRAY + modeDescription);
                }
            }
        });
        return null;
    }
}

