/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.server.DismountCamera;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="securitycraft", value={Side.CLIENT})
public class CameraController {
    public static int previousCameraType;
    private static boolean wasUpPressed;
    private static boolean wasDownPressed;
    private static boolean wasLeftPressed;
    private static boolean wasRightPressed;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Entity renderViewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (renderViewEntity instanceof SecurityCamera) {
            SecurityCamera cam = (SecurityCamera)renderViewEntity;
            GameSettings options = Minecraft.func_71410_x().field_71474_y;
            if (event.phase == TickEvent.Phase.END) {
                if (wasUpPressed) {
                    CameraController.moveViewUp(cam);
                    KeyBinding.func_74510_a((int)options.field_74351_w.func_151463_i(), (boolean)true);
                }
                if (wasDownPressed) {
                    CameraController.moveViewDown(cam);
                    KeyBinding.func_74510_a((int)options.field_74368_y.func_151463_i(), (boolean)true);
                }
                if (wasLeftPressed) {
                    CameraController.moveViewHorizontally(cam, cam.field_70177_z, cam.field_70177_z - cam.cameraSpeed * cam.zoomAmount);
                    KeyBinding.func_74510_a((int)options.field_74370_x.func_151463_i(), (boolean)true);
                }
                if (wasRightPressed) {
                    CameraController.moveViewHorizontally(cam, cam.field_70177_z, cam.field_70177_z + cam.cameraSpeed * cam.zoomAmount);
                    KeyBinding.func_74510_a((int)options.field_74366_z.func_151463_i(), (boolean)true);
                }
                if (KeyBindings.cameraZoomIn.func_151470_d()) {
                    CameraController.zoomIn(cam);
                } else if (KeyBindings.cameraZoomOut.func_151470_d()) {
                    CameraController.zoomOut(cam);
                } else {
                    cam.zooming = false;
                }
                if (KeyBindings.cameraEmitRedstone.func_151468_f()) {
                    CameraController.emitRedstone(cam);
                }
                if (KeyBindings.cameraActivateNightVision.func_151468_f()) {
                    CameraController.giveNightVision(cam);
                }
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                double yRotChange = player.field_70177_z - player.field_175164_bL;
                double xRotChange = player.field_70125_A - player.field_175165_bM;
                if (yRotChange != 0.0 || xRotChange != 0.0) {
                    player.field_71174_a.func_147297_a((Packet)new CPacketPlayer.Rotation(player.field_70177_z, player.field_70125_A, player.field_70122_E));
                }
            }
        }
    }

    public static void handleKeybinds() {
        GameSettings options = Minecraft.func_71410_x().field_71474_y;
        wasUpPressed = options.field_74351_w.func_151470_d();
        if (wasUpPressed) {
            KeyBinding.func_74510_a((int)options.field_74351_w.func_151463_i(), (boolean)false);
        }
        if (wasDownPressed = options.field_74368_y.func_151470_d()) {
            KeyBinding.func_74510_a((int)options.field_74368_y.func_151463_i(), (boolean)false);
        }
        if (wasLeftPressed = options.field_74370_x.func_151470_d()) {
            KeyBinding.func_74510_a((int)options.field_74370_x.func_151463_i(), (boolean)false);
        }
        if (wasRightPressed = options.field_74366_z.func_151470_d()) {
            KeyBinding.func_74510_a((int)options.field_74366_z.func_151463_i(), (boolean)false);
        }
        if (options.field_74311_E.func_151470_d()) {
            CameraController.dismount();
            KeyBinding.func_74510_a((int)options.field_74311_E.func_151463_i(), (boolean)false);
        }
    }

    private static void dismount() {
        SecurityCraft.network.sendToServer((IMessage)new DismountCamera());
    }

    public static void moveViewUp(SecurityCamera cam) {
        float next = cam.field_70125_A - cam.cameraSpeed * cam.zoomAmount;
        if (cam.isCameraDown()) {
            if (next > 40.0f) {
                cam.func_70101_b(cam.field_70177_z, next);
            }
        } else if (next > -25.0f) {
            cam.func_70101_b(cam.field_70177_z, next);
        }
    }

    public static void moveViewDown(SecurityCamera cam) {
        float next = cam.field_70125_A + cam.cameraSpeed * cam.zoomAmount;
        if (cam.isCameraDown()) {
            if (next < 90.0f) {
                cam.func_70101_b(cam.field_70177_z, next);
            }
        } else if (next < 60.0f) {
            cam.func_70101_b(cam.field_70177_z, next);
        }
    }

    public static void moveViewHorizontally(SecurityCamera cam, float yRot, float next) {
        IBlockState state = cam.field_70170_p.func_180495_p(new BlockPos(cam.field_70165_t, cam.field_70163_u, cam.field_70161_v));
        if (state.func_177228_b().containsKey((Object)SecurityCameraBlock.FACING)) {
            float checkNext = next;
            if (checkNext < 0.0f) {
                checkNext += 360.0f;
            }
            boolean shouldSetRotation = false;
            switch ((EnumFacing)state.func_177229_b((IProperty)SecurityCameraBlock.FACING)) {
                case NORTH: {
                    shouldSetRotation = checkNext > 90.0f && checkNext < 270.0f;
                    break;
                }
                case SOUTH: {
                    shouldSetRotation = checkNext > 270.0f || checkNext < 90.0f;
                    break;
                }
                case EAST: {
                    shouldSetRotation = checkNext > 180.0f && checkNext < 360.0f;
                    break;
                }
                case WEST: {
                    shouldSetRotation = checkNext > 0.0f && checkNext < 180.0f;
                    break;
                }
                case DOWN: {
                    shouldSetRotation = true;
                    break;
                }
                default: {
                    shouldSetRotation = false;
                }
            }
            if (shouldSetRotation) {
                cam.field_70177_z = next;
            }
        }
    }

    public static void zoomIn(SecurityCamera cam) {
        if (!cam.zooming) {
            Minecraft.func_71410_x().field_71441_e.func_184156_a(new BlockPos(cam.field_70165_t, cam.field_70163_u, cam.field_70161_v), SCSounds.CAMERAZOOMIN.event, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        }
        cam.zooming = true;
        cam.zoomAmount = Math.max(cam.zoomAmount - 0.1f, 0.1f);
    }

    public static void zoomOut(SecurityCamera cam) {
        if (!cam.zooming) {
            Minecraft.func_71410_x().field_71441_e.func_184156_a(new BlockPos(cam.field_70165_t, cam.field_70163_u, cam.field_70161_v), SCSounds.CAMERAZOOMIN.event, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
        }
        cam.zooming = true;
        cam.zoomAmount = Math.min(cam.zoomAmount + 0.1f, 1.4f);
    }

    public static void emitRedstone(SecurityCamera cam) {
        if (cam.redstoneCooldown == 0) {
            cam.toggleRedstonePower();
            cam.redstoneCooldown = 30;
        }
    }

    public static void giveNightVision(SecurityCamera cam) {
        if (cam.toggleNightVisionCooldown == 0) {
            cam.toggleNightVision();
        }
    }
}

