/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.itemblocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedCrystalQuartzSlabBlock;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockReinforcedCrystalQuartzSlab
extends ItemBlock {
    private BlockSlab singleSlab = (BlockSlab)SCContent.reinforcedCrystalQuartzSlab;
    private Block doubleSlab = SCContent.reinforcedDoubleCrystalQuartzSlab;

    public ItemBlockReinforcedCrystalQuartzSlab(Block block) {
        super(block);
    }

    public int func_77647_b(int meta) {
        return meta;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190916_E() == 0) {
            return EnumActionResult.FAIL;
        }
        if (!player.func_175151_a(pos.func_177972_a(side), side, stack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof ReinforcedCrystalQuartzSlabBlock) {
            BlockSlab.EnumBlockHalf half = (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)BlockSlab.field_176554_a);
            TileEntity tile = world.func_175625_s(pos);
            Owner owner = null;
            if (tile instanceof IOwnable) {
                IOwnable ownable = (IOwnable)tile;
                owner = ownable.getOwner();
                if (!ownable.isOwnedBy(player)) {
                    if (!world.field_72995_K) {
                        PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("messages.securitycraft:reinforcedSlab", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:reinforcedSlab.cannotDoubleSlab", new Object[0]), TextFormatting.RED);
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
            if (side == EnumFacing.UP && half == BlockSlab.EnumBlockHalf.BOTTOM || side == EnumFacing.DOWN && half == BlockSlab.EnumBlockHalf.TOP) {
                IBlockState doubleState = this.doubleSlab.func_176223_P();
                doubleState.func_177230_c();
                if (world.func_72855_b(doubleState.func_185890_d((IBlockAccess)world, pos)) && world.func_180501_a(pos, doubleState, 3)) {
                    world.func_184133_a(player, pos, this.doubleSlab.func_185467_w().func_185841_e(), SoundCategory.BLOCKS, (this.doubleSlab.func_185467_w().func_185843_a() + 1.0f) / 2.0f, this.doubleSlab.func_185467_w().func_185847_b() * 0.8f);
                    stack.func_190918_g(1);
                    if (owner != null) {
                        ((IOwnable)world.func_175625_s(pos)).setOwner(owner.getUUID(), owner.getName());
                    }
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return this.tryPlace(stack, world, player, pos.func_177972_a(side)) ? EnumActionResult.SUCCESS : super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        IBlockState updatedState;
        BlockPos originalPos = pos;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.singleSlab) {
            boolean isTop;
            boolean bl = isTop = state.func_177229_b((IProperty)BlockSlab.field_176554_a) == BlockSlab.EnumBlockHalf.TOP;
            if (side == EnumFacing.UP && !isTop || side == EnumFacing.DOWN && isTop) {
                return true;
            }
        }
        return (updatedState = world.func_180495_p(pos = pos.func_177972_a(side))).func_177230_c() == this.singleSlab ? true : super.func_179222_a(world, originalPos, side, player, stack);
    }

    private boolean tryPlace(ItemStack stack, World world, EntityPlayer player, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Owner owner = null;
        if (world.func_175625_s(pos) instanceof IOwnable) {
            owner = ((IOwnable)world.func_175625_s(pos)).getOwner();
        }
        if (state.func_177230_c() == this.singleSlab) {
            IBlockState newState = this.doubleSlab.func_176223_P();
            if (world.func_72855_b(newState.func_185890_d((IBlockAccess)world, pos)) && world.func_180501_a(pos, newState, 3)) {
                world.func_184133_a(player, pos, this.doubleSlab.func_185467_w().func_185841_e(), SoundCategory.BLOCKS, (this.doubleSlab.func_185467_w().func_185843_a() + 1.0f) / 2.0f, this.doubleSlab.func_185467_w().func_185847_b() * 0.8f);
                stack.func_190918_g(1);
                if (owner != null) {
                    ((IOwnable)world.func_175625_s(pos)).setOwner(owner.getUUID(), owner.getName());
                }
            }
            return true;
        }
        return false;
    }
}

