/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.ReinforcedCauldronBlockEntity;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BriefcaseItem
extends Item {
    private static final Style GRAY_STYLE = new Style().func_150238_a(TextFormatting.GRAY);

    public boolean func_77662_d() {
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (state.func_177230_c() instanceof BlockCauldron) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof ReinforcedCauldronBlockEntity && !((ReinforcedCauldronBlockEntity)te).isAllowedToInteract(player)) {
                return EnumActionResult.FAIL;
            }
            int level = (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a);
            if (level > 0 && this.hasColor(stack)) {
                this.removeColor(stack);
                ((BlockCauldron)state.func_177230_c()).func_176590_a(world, pos, state, level - 1);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        this.handle(stack, world, player, hand);
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        this.handle(stack, world, player, hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    private void handle(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.func_77978_p().func_74764_b("passcode")) {
                player.openGui((Object)SecurityCraft.instance, 13, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            } else {
                player.openGui((Object)SecurityCraft.instance, 14, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack briefcase, World world, List<String> tooltip, ITooltipFlag flag) {
        String ownerName = BriefcaseItem.getOwnerName(briefcase);
        if (!ownerName.isEmpty()) {
            tooltip.add(Utils.localize("tooltip.securitycraft:briefcase.owner", ownerName).func_150255_a(GRAY_STYLE).func_150254_d());
        }
    }

    public boolean hasColor(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_150297_b("display", 10) ? tag.func_74775_l("display").func_150297_b("color", 3) : false;
    }

    public int getColor(ItemStack stack) {
        NBTTagCompound displayTag;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && (displayTag = tag.func_74775_l("display")) != null && displayTag.func_150297_b("color", 3)) {
            return displayTag.func_74762_e("color");
        }
        return 0x333333;
    }

    public void removeColor(ItemStack stack) {
        NBTTagCompound displayTag;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && (displayTag = tag.func_74775_l("display")).func_74764_b("color")) {
            displayTag.func_82580_o("color");
        }
    }

    public void setColor(ItemStack stack, int color) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        NBTTagCompound displayTag = tag.func_74775_l("display");
        if (!tag.func_150297_b("display", 10)) {
            tag.func_74782_a("display", (NBTBase)displayTag);
        }
        displayTag.func_74768_a("color", color);
    }

    public static boolean isOwnedBy(ItemStack briefcase, EntityPlayer player) {
        if (!briefcase.func_77942_o()) {
            return true;
        }
        String ownerName = BriefcaseItem.getOwnerName(briefcase);
        String ownerUUID = BriefcaseItem.getOwnerUUID(briefcase);
        return ownerName.isEmpty() || ownerUUID.equals(player.func_110124_au().toString()) || ownerUUID.equals("ownerUUID") && ownerName.equals(player.func_70005_c_());
    }

    public static String getOwnerName(ItemStack briefcase) {
        return briefcase.func_77942_o() ? briefcase.func_77978_p().func_74779_i("owner") : "";
    }

    public static String getOwnerUUID(ItemStack briefcase) {
        return briefcase.func_77942_o() ? briefcase.func_77978_p().func_74779_i("ownerUUID") : "";
    }
}

