/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.items.BriefcaseItem;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class UniversalKeyChangerItem
extends Item {
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        EnumActionResult briefcaseResult = this.handleBriefcase(player, hand).func_188397_a();
        if (briefcaseResult != EnumActionResult.PASS) {
            return briefcaseResult;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPasswordProtected) {
            if (((IOwnable)te).isOwnedBy(player)) {
                player.openGui((Object)SecurityCraft.instance, 16, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return EnumActionResult.SUCCESS;
            }
            if (!(te.func_145838_q() instanceof DisguisableBlock) || ((ItemBlock)((DisguisableBlock)te.func_145838_q()).getDisguisedStack((IBlockAccess)world, pos).func_77973_b()).func_179223_d() instanceof DisguisableBlock) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize("item.securitycraft:universalKeyChanger.name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(((IOwnable)te).getOwner())), TextFormatting.RED);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        return this.handleBriefcase(player, hand);
    }

    private ActionResult<ItemStack> handleBriefcase(EntityPlayer player, EnumHand hand) {
        ItemStack keyChanger = player.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND && player.func_184592_cb().func_77973_b() == SCContent.briefcase) {
            ItemStack briefcase = player.func_184592_cb();
            if (BriefcaseItem.isOwnedBy(briefcase, player)) {
                if (briefcase.func_77942_o() && briefcase.func_77978_p().func_74764_b("passcode")) {
                    briefcase.func_77978_p().func_82580_o("passcode");
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.universalKeyChanger.func_77658_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.passcodeReset", new Object[0]), TextFormatting.GREEN);
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)keyChanger);
                }
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.universalKeyChanger.func_77658_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.noPasscode", new Object[0]), TextFormatting.RED);
            } else {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.universalKeyChanger.func_77658_a() + ".name", new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:universalKeyChanger.briefcase.notOwned", new Object[0]), TextFormatting.RED);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)keyChanger);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)keyChanger);
    }
}

