/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CheckPassword
implements IMessage {
    private String password;
    private int x;
    private int y;
    private int z;

    public CheckPassword() {
    }

    public CheckPassword(int x, int y, int z, String code) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.password = code;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.password);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.password = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static class Handler
    implements IMessageHandler<CheckPassword, IMessage> {
        public IMessage onMessage(CheckPassword message, MessageContext ctx) {
            LevelUtils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                BlockPos pos = new BlockPos(message.x, message.y, message.z);
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                TileEntity te = player.field_70170_p.func_175625_s(pos);
                if (te instanceof IPasswordProtected) {
                    IPasswordProtected passwordProtected = (IPasswordProtected)te;
                    boolean isPasscodeCorrect = passwordProtected.getPassword().equals(message.password);
                    if (passwordProtected.isOnCooldown()) {
                        return;
                    }
                    if (isPasscodeCorrect) {
                        player.func_71053_j();
                        passwordProtected.activate((EntityPlayer)player);
                    } else {
                        passwordProtected.onIncorrectPasscodeEntered((EntityPlayer)player, message.password);
                    }
                }
            });
            return null;
        }
    }
}

