/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SyncAlarmSettings
implements IMessage {
    private BlockPos pos;
    private SoundEvent soundEvent;
    private int soundLength;

    public SyncAlarmSettings() {
    }

    public SyncAlarmSettings(BlockPos pos, ResourceLocation soundEvent, int soundLength) {
        this.pos = pos;
        this.soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundEvent);
        this.soundLength = soundLength;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeRegistryEntry((ByteBuf)buf, (IForgeRegistryEntry)this.soundEvent);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.soundLength, (int)5);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.soundEvent = (SoundEvent)ByteBufUtils.readRegistryEntry((ByteBuf)buf, (IForgeRegistry)ForgeRegistries.SOUND_EVENTS);
        this.soundLength = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
    }

    public static class Handler
    implements IMessageHandler<SyncAlarmSettings, IMessage> {
        public IMessage onMessage(SyncAlarmSettings message, MessageContext context) {
            LevelUtils.addScheduledTask(context.getServerHandler().field_147369_b.field_70170_p, () -> {
                AlarmBlockEntity be;
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                TileEntity tile = player.field_70170_p.func_175625_s(message.pos);
                if (tile instanceof AlarmBlockEntity && (be = (AlarmBlockEntity)tile).isOwnedBy((EntityPlayer)player)) {
                    if (!message.soundEvent.equals(be.getSound())) {
                        be.setSound(message.soundEvent);
                    }
                    if (message.soundLength != be.getSoundLength()) {
                        be.setSoundLength(message.soundLength);
                    }
                }
            });
            return null;
        }
    }
}

