/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SyncBlockPocketManager
implements IMessage {
    private BlockPos pos;
    private int size;
    private boolean showOutline;
    private int autoBuildOffset;
    private int color;

    public SyncBlockPocketManager() {
    }

    public SyncBlockPocketManager(BlockPos pos, int size, boolean showOutline, int autoBuildOffset, int color) {
        this.pos = pos;
        this.size = size;
        this.showOutline = showOutline;
        this.autoBuildOffset = autoBuildOffset;
        this.color = color;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.size = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.showOutline = buf.readBoolean();
        this.autoBuildOffset = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.color = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.size, (int)5);
        buf.writeBoolean(this.showOutline);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.autoBuildOffset, (int)5);
        buf.writeInt(this.color);
    }

    public static class Handler
    implements IMessageHandler<SyncBlockPocketManager, IMessage> {
        public IMessage onMessage(SyncBlockPocketManager message, MessageContext ctx) {
            LevelUtils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                BlockPos pos = message.pos;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                World world = player.field_70170_p;
                TileEntity te = world.func_175625_s(pos);
                if (world.func_175667_e(pos) && te instanceof BlockPocketManagerBlockEntity && ((BlockPocketManagerBlockEntity)te).isOwnedBy((EntityPlayer)player)) {
                    BlockPocketManagerBlockEntity bpm = (BlockPocketManagerBlockEntity)te;
                    IBlockState state = world.func_180495_p(pos);
                    bpm.size = message.size;
                    bpm.showOutline = message.showOutline;
                    bpm.autoBuildOffset = message.autoBuildOffset;
                    bpm.setColor(message.color);
                    bpm.func_70296_d();
                    world.func_184138_a(pos, state, state, 2);
                }
            });
            return null;
        }
    }
}

