/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SyncProjector
implements IMessage {
    private BlockPos pos;
    private int data;
    private DataType dataType;

    public SyncProjector() {
    }

    public SyncProjector(BlockPos pos, int data, DataType dataType) {
        this.pos = pos;
        this.data = data;
        this.dataType = dataType;
    }

    public SyncProjector(BlockPos pos, IBlockState state) {
        this.pos = pos;
        this.data = Block.func_176210_f((IBlockState)state);
        this.dataType = DataType.BLOCK_STATE;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.dataType = DataType.values()[ByteBufUtils.readVarInt((ByteBuf)buf, (int)5)];
        this.data = this.dataType == DataType.HORIZONTAL ? (buf.readBoolean() ? 1 : 0) : ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.dataType.ordinal(), (int)5);
        if (this.dataType == DataType.HORIZONTAL) {
            buf.writeBoolean(this.data == 1);
        } else {
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.data, (int)5);
        }
    }

    public static enum DataType {
        WIDTH,
        HEIGHT,
        RANGE,
        OFFSET,
        HORIZONTAL,
        BLOCK_STATE,
        INVALID;

    }

    public static class Handler
    implements IMessageHandler<SyncProjector, IMessage> {
        public IMessage onMessage(SyncProjector message, MessageContext ctx) {
            LevelUtils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                BlockPos pos = message.pos;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                World world = player.field_70170_p;
                TileEntity te = world.func_175625_s(pos);
                if (world.func_175667_e(pos) && te instanceof ProjectorBlockEntity && ((ProjectorBlockEntity)te).isOwnedBy((EntityPlayer)player)) {
                    ProjectorBlockEntity projector = (ProjectorBlockEntity)te;
                    IBlockState state = world.func_180495_p(pos);
                    switch (message.dataType) {
                        case WIDTH: {
                            projector.setProjectionWidth(message.data);
                            break;
                        }
                        case HEIGHT: {
                            projector.setProjectionHeight(message.data);
                            break;
                        }
                        case RANGE: {
                            projector.setProjectionRange(message.data);
                            break;
                        }
                        case OFFSET: {
                            projector.setProjectionOffset(message.data);
                            break;
                        }
                        case HORIZONTAL: {
                            projector.setHorizontal(message.data == 1);
                            break;
                        }
                        case BLOCK_STATE: {
                            projector.setProjectedState(Block.func_176220_d((int)message.data));
                            break;
                        }
                    }
                    world.func_184138_a(pos, state, state, 2);
                }
            });
            return null;
        }
    }
}

