/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SyncTrophySystem
implements IMessage {
    private BlockPos pos;
    private String projectileType;
    private boolean allowed;

    public SyncTrophySystem() {
    }

    public SyncTrophySystem(BlockPos pos, EntityEntry projectileType, boolean allowed) {
        this.pos = pos;
        this.projectileType = projectileType.getRegistryName().toString();
        this.allowed = allowed;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.projectileType);
        buf.writeBoolean(this.allowed);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.projectileType = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.allowed = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<SyncTrophySystem, IMessage> {
        public IMessage onMessage(SyncTrophySystem message, MessageContext ctx) {
            LevelUtils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                EntityEntry projectileType = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(message.projectileType));
                if (projectileType != null) {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    World world = player.field_70170_p;
                    BlockPos pos = message.pos;
                    boolean allowed = message.allowed;
                    TileEntity te = world.func_175625_s(pos);
                    if (te instanceof TrophySystemBlockEntity && ((TrophySystemBlockEntity)te).isOwnedBy((EntityPlayer)player)) {
                        IBlockState state = world.func_180495_p(pos);
                        ((TrophySystemBlockEntity)te).setFilter(projectileType, allowed);
                        world.func_184138_a(pos, state, state, 2);
                    }
                }
            });
            return null;
        }
    }
}

