/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ToggleBlockPocketManager
implements IMessage {
    private BlockPos pos;
    private int dimension;
    private int size;
    private boolean enabling;

    public ToggleBlockPocketManager() {
    }

    public ToggleBlockPocketManager(BlockPocketManagerBlockEntity te, boolean enabling, int size) {
        this.pos = te.func_174877_v();
        this.dimension = te.func_145831_w().field_73011_w.getDimension();
        this.enabling = enabling;
        this.size = size;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.dimension = buf.readInt();
        this.enabling = buf.readBoolean();
        this.size = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.dimension);
        buf.writeBoolean(this.enabling);
        buf.writeInt(this.size);
    }

    public static class Handler
    implements IMessageHandler<ToggleBlockPocketManager, IMessage> {
        public IMessage onMessage(ToggleBlockPocketManager message, MessageContext ctx) {
            LevelUtils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                World world = player.field_70170_p;
                TileEntity te = world.func_175625_s(message.pos);
                if (te instanceof BlockPocketManagerBlockEntity && ((BlockPocketManagerBlockEntity)te).isOwnedBy((EntityPlayer)player)) {
                    ((BlockPocketManagerBlockEntity)te).size = message.size;
                    if (message.enabling) {
                        ((BlockPocketManagerBlockEntity)te).enableMultiblock();
                    } else {
                        ((BlockPocketManagerBlockEntity)te).disableMultiblock();
                    }
                }
            });
            return null;
        }
    }
}

