/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.util.ArrayList;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.inventory.GenericMenu;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.misc.CameraView;
import net.geforcemods.securitycraft.network.server.MountCamera;
import net.geforcemods.securitycraft.network.server.RemoveCameraTag;
import net.geforcemods.securitycraft.screen.components.HoverChecker;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CameraMonitorScreen
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private InventoryPlayer playerInventory;
    private CameraMonitorItem cameraMonitor;
    private NBTTagCompound nbtTag;
    private GuiButton prevPageButton;
    private GuiButton nextPageButton;
    private GuiButton[] cameraButtons = new GuiButton[10];
    private GuiButton[] unbindButtons = new GuiButton[10];
    private HoverChecker[] hoverCheckers = new HoverChecker[10];
    private SecurityCameraBlockEntity[] cameraTEs = new SecurityCameraBlockEntity[10];
    private int[] cameraViewDim = new int[10];
    private int page = 1;

    public CameraMonitorScreen(InventoryPlayer inventory, CameraMonitorItem item, NBTTagCompound itemNBTTag) {
        super((Container)new GenericMenu(inventory, null));
        this.playerInventory = inventory;
        this.cameraMonitor = item;
        this.nbtTag = itemNBTTag;
    }

    public CameraMonitorScreen(InventoryPlayer inventory, CameraMonitorItem item, NBTTagCompound itemNBTTag, int page) {
        this(inventory, item, itemNBTTag);
        this.page = page;
    }

    public void func_73866_w_() {
        int i;
        super.func_73866_w_();
        this.prevPageButton = new GuiButton(-1, this.field_146294_l / 2 - 68, this.field_146295_m / 2 + 40, 20, 20, "<");
        this.nextPageButton = new GuiButton(0, this.field_146294_l / 2 + 52, this.field_146295_m / 2 + 40, 20, 20, ">");
        this.field_146292_n.add(this.prevPageButton);
        this.field_146292_n.add(this.nextPageButton);
        this.cameraButtons[0] = new GuiButton(1, this.field_146294_l / 2 - 38, this.field_146295_m / 2 - 60 + 10, 20, 20, "#");
        this.cameraButtons[1] = new GuiButton(2, this.field_146294_l / 2 - 8, this.field_146295_m / 2 - 60 + 10, 20, 20, "#");
        this.cameraButtons[2] = new GuiButton(3, this.field_146294_l / 2 + 22, this.field_146295_m / 2 - 60 + 10, 20, 20, "#");
        this.cameraButtons[3] = new GuiButton(4, this.field_146294_l / 2 - 38, this.field_146295_m / 2 - 30 + 10, 20, 20, "#");
        this.cameraButtons[4] = new GuiButton(5, this.field_146294_l / 2 - 8, this.field_146295_m / 2 - 30 + 10, 20, 20, "#");
        this.cameraButtons[5] = new GuiButton(6, this.field_146294_l / 2 + 22, this.field_146295_m / 2 - 30 + 10, 20, 20, "#");
        this.cameraButtons[6] = new GuiButton(7, this.field_146294_l / 2 - 38, this.field_146295_m / 2 + 10, 20, 20, "#");
        this.cameraButtons[7] = new GuiButton(8, this.field_146294_l / 2 - 8, this.field_146295_m / 2 + 10, 20, 20, "#");
        this.cameraButtons[8] = new GuiButton(9, this.field_146294_l / 2 + 22, this.field_146295_m / 2 + 10, 20, 20, "#");
        this.cameraButtons[9] = new GuiButton(10, this.field_146294_l / 2 - 38, this.field_146295_m / 2 + 40, 80, 20, "#");
        this.unbindButtons[0] = new GuiButton(11, this.field_146294_l / 2 - 19, this.field_146295_m / 2 - 68 + 10, 8, 8, "x");
        this.unbindButtons[1] = new GuiButton(12, this.field_146294_l / 2 + 11, this.field_146295_m / 2 - 68 + 10, 8, 8, "x");
        this.unbindButtons[2] = new GuiButton(13, this.field_146294_l / 2 + 41, this.field_146295_m / 2 - 68 + 10, 8, 8, "x");
        this.unbindButtons[3] = new GuiButton(14, this.field_146294_l / 2 - 19, this.field_146295_m / 2 - 38 + 10, 8, 8, "x");
        this.unbindButtons[4] = new GuiButton(15, this.field_146294_l / 2 + 11, this.field_146295_m / 2 - 38 + 10, 8, 8, "x");
        this.unbindButtons[5] = new GuiButton(16, this.field_146294_l / 2 + 41, this.field_146295_m / 2 - 38 + 10, 8, 8, "x");
        this.unbindButtons[6] = new GuiButton(17, this.field_146294_l / 2 - 19, this.field_146295_m / 2 + 2, 8, 8, "x");
        this.unbindButtons[7] = new GuiButton(18, this.field_146294_l / 2 + 11, this.field_146295_m / 2 + 2, 8, 8, "x");
        this.unbindButtons[8] = new GuiButton(19, this.field_146294_l / 2 + 41, this.field_146295_m / 2 + 2, 8, 8, "x");
        this.unbindButtons[9] = new GuiButton(20, this.field_146294_l / 2 + 41, this.field_146295_m / 2 + 32, 8, 8, "x");
        for (i = 0; i < 10; ++i) {
            GuiButton button = this.cameraButtons[i];
            int camID = button.field_146127_k + (this.page - 1) * 10;
            ArrayList<CameraView> views = this.cameraMonitor.getCameraPositions(this.nbtTag);
            CameraView view = views.get(camID - 1);
            button.field_146126_j = button.field_146126_j + camID;
            this.field_146292_n.add(button);
            if (view != null) {
                if (view.dimension != Minecraft.func_71410_x().field_71439_g.field_71093_bK) {
                    this.hoverCheckers[button.field_146127_k - 1] = new HoverChecker(button);
                    this.cameraViewDim[button.field_146127_k - 1] = view.dimension;
                }
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                TileEntity te = world.func_175625_s(view.getLocation());
                this.cameraTEs[button.field_146127_k - 1] = te instanceof SecurityCameraBlockEntity ? (SecurityCameraBlockEntity)te : null;
                this.hoverCheckers[button.field_146127_k - 1] = new HoverChecker(button);
                if (this.cameraTEs[button.field_146127_k - 1] == null || !this.cameraTEs[button.field_146127_k - 1].isDisabled()) continue;
                button.field_146124_l = false;
                continue;
            }
            button.field_146124_l = false;
            this.unbindButtons[button.field_146127_k - 1].field_146124_l = false;
            this.cameraTEs[button.field_146127_k - 1] = null;
        }
        for (i = 0; i < 10; ++i) {
            this.field_146292_n.add(this.unbindButtons[i]);
        }
        if (this.page == 1) {
            this.prevPageButton.field_146124_l = false;
        }
        if (this.page == 3 || this.cameraMonitor.getCameraPositions(this.nbtTag).size() < this.page * 10 + 1) {
            this.nextPageButton.field_146124_l = false;
        }
        for (i = this.cameraMonitor.getCameraPositions(this.nbtTag).size() + 1; i <= this.page * 10; ++i) {
            this.cameraButtons[i - 1 - (this.page - 1) * 10].field_146124_l = false;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (int i = 0; i < this.hoverCheckers.length; ++i) {
            if (this.hoverCheckers[i] == null || !this.hoverCheckers[i].checkHover(mouseX, mouseY) || this.cameraTEs[i] == null) continue;
            if (this.cameraTEs[i].isDisabled()) {
                this.func_146279_a(Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]).func_150254_d(), mouseX, mouseY);
                continue;
            }
            if (!this.cameraTEs[i].func_145818_k_()) continue;
            this.drawHoveringText(this.field_146297_k.field_71466_p.func_78271_c(Utils.localize("gui.securitycraft:monitor.cameraName", new Object[0]).func_150254_d().replace("#", this.cameraTEs[i].func_70005_c_()), 150), mouseX, mouseY, this.field_146297_k.field_71466_p);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == -1) {
            this.field_146297_k.func_147108_a((GuiScreen)new CameraMonitorScreen(this.playerInventory, this.cameraMonitor, this.nbtTag, this.page - 1));
        } else if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)new CameraMonitorScreen(this.playerInventory, this.cameraMonitor, this.nbtTag, this.page + 1));
        } else if (button.field_146127_k < 11) {
            int camID = button.field_146127_k + (this.page - 1) * 10;
            BlockPos cameraPos = this.cameraMonitor.getCameraPositions(this.nbtTag).get(camID - 1).getLocation();
            TileEntity te = this.field_146297_k.field_71441_e.func_175625_s(cameraPos);
            if (te instanceof SecurityCameraBlockEntity && ((SecurityCameraBlockEntity)te).isDisabled()) {
                button.field_146124_l = false;
                return;
            }
            SecurityCraft.network.sendToServer((IMessage)new MountCamera(cameraPos));
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        } else {
            int camID = button.field_146127_k - 10 + (this.page - 1) * 10;
            SecurityCraft.network.sendToServer((IMessage)new RemoveCameraTag(camID));
            this.nbtTag.func_82580_o(CameraMonitorItem.getTagNameFromPosition(this.nbtTag, this.cameraMonitor.getCameraPositions(this.nbtTag).get(camID - 1)));
            button.field_146124_l = false;
            this.cameraButtons[(camID - 1) % 10].field_146124_l = false;
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(Utils.localize("gui.securitycraft:monitor.selectCameras", new Object[0]).func_150254_d(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(Utils.localize("gui.securitycraft:monitor.selectCameras", new Object[0]).func_150254_d()) / 2, 6, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public boolean func_73868_f() {
        return false;
    }
}

