/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.io.IOException;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.inventory.GenericMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.CheckPassword;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class CheckPasswordScreen
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private static final int MAX_CHARS = 20;
    private final String cooldownText1 = new TextComponentTranslation("gui.securitycraft:password.cooldown1", new Object[0]).func_150254_d();
    private int cooldownText1XPos;
    private IPasswordProtected be;
    private char[] allowedChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\b', '\u001b'};
    private String title;
    private GuiTextField keycodeTextbox;
    private String currentString = "";
    private boolean wasOnCooldownLastRenderTick = false;

    public CheckPasswordScreen(InventoryPlayer inventoryPlayer, TileEntity tileEntity) {
        super((Container)new GenericMenu(inventoryPlayer, tileEntity));
        this.be = (IPasswordProtected)tileEntity;
        this.title = tileEntity.func_145748_c_().func_150254_d();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.cooldownText1XPos = this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.cooldownText1) / 2;
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.add(new ClickButton(0, this.field_146294_l / 2 - 33, this.field_146295_m / 2 - 45, 20, 20, "1", b -> this.addNumberToString(1)));
        this.field_146292_n.add(new ClickButton(1, this.field_146294_l / 2 - 8, this.field_146295_m / 2 - 45, 20, 20, "2", b -> this.addNumberToString(2)));
        this.field_146292_n.add(new ClickButton(2, this.field_146294_l / 2 + 17, this.field_146295_m / 2 - 45, 20, 20, "3", b -> this.addNumberToString(3)));
        this.field_146292_n.add(new ClickButton(3, this.field_146294_l / 2 - 33, this.field_146295_m / 2 - 20, 20, 20, "4", b -> this.addNumberToString(4)));
        this.field_146292_n.add(new ClickButton(4, this.field_146294_l / 2 - 8, this.field_146295_m / 2 - 20, 20, 20, "5", b -> this.addNumberToString(5)));
        this.field_146292_n.add(new ClickButton(5, this.field_146294_l / 2 + 17, this.field_146295_m / 2 - 20, 20, 20, "6", b -> this.addNumberToString(6)));
        this.field_146292_n.add(new ClickButton(6, this.field_146294_l / 2 - 33, this.field_146295_m / 2 + 5, 20, 20, "7", b -> this.addNumberToString(7)));
        this.field_146292_n.add(new ClickButton(7, this.field_146294_l / 2 - 8, this.field_146295_m / 2 + 5, 20, 20, "8", b -> this.addNumberToString(8)));
        this.field_146292_n.add(new ClickButton(8, this.field_146294_l / 2 + 17, this.field_146295_m / 2 + 5, 20, 20, "9", b -> this.addNumberToString(9)));
        this.field_146292_n.add(new ClickButton(9, this.field_146294_l / 2 - 33, this.field_146295_m / 2 + 30, 20, 20, "\u2190", b -> this.removeLastCharacter()));
        this.field_146292_n.add(new ClickButton(10, this.field_146294_l / 2 - 8, this.field_146295_m / 2 + 30, 20, 20, "0", b -> this.addNumberToString(0)));
        this.field_146292_n.add(new ClickButton(11, this.field_146294_l / 2 + 17, this.field_146295_m / 2 + 30, 20, 20, "\u2714", b -> this.checkCode(this.currentString)));
        this.keycodeTextbox = new GuiTextField(11, this.field_146289_q, this.field_146294_l / 2 - 37, this.field_146295_m / 2 - 62, 77, 12){

            public boolean func_146201_a(char typedChar, int keyCode) {
                boolean returnValue;
                boolean bl = returnValue = this.field_146226_p && super.func_146201_a(typedChar, keyCode);
                if (returnValue) {
                    CheckPasswordScreen.this.setTextboxCensoredText(this, this.func_146179_b());
                }
                return returnValue;
            }
        };
        this.keycodeTextbox.func_146193_g(-1);
        this.keycodeTextbox.func_146204_h(-1);
        this.keycodeTextbox.func_146185_a(true);
        this.keycodeTextbox.func_146203_f(20);
        if (this.be.isOnCooldown()) {
            this.toggleChildrenActive(false);
        } else {
            this.keycodeTextbox.func_146195_b(true);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        this.keycodeTextbox.func_146194_f();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.title) / 2, 6, 0x404040);
        if (this.be.isOnCooldown()) {
            long cooldownEnd = this.be.getCooldownEnd();
            long secondsLeft = Math.max(cooldownEnd - System.currentTimeMillis(), 0L) / 1000L + 1L;
            String text = new TextComponentTranslation("gui.securitycraft:password.cooldown2", new Object[]{secondsLeft}).func_150254_d();
            this.field_146289_q.func_78276_b(this.cooldownText1, this.cooldownText1XPos, this.field_147000_g / 2 + 55, 0x404040);
            this.field_146289_q.func_78276_b(text, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(text) / 2, this.field_147000_g / 2 + 65, 0x404040);
            if (!this.wasOnCooldownLastRenderTick) {
                this.wasOnCooldownLastRenderTick = true;
            }
        } else if (this.wasOnCooldownLastRenderTick) {
            this.wasOnCooldownLastRenderTick = false;
            this.toggleChildrenActive(true);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.be.isOnCooldown()) {
            if (keyCode == 14 && this.currentString.length() > 0) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("random.click")), 0.15f, 1.0f);
                this.removeLastCharacter();
            } else if (keyCode == 28 || keyCode == 156) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("random.click")), 0.15f, 1.0f);
                this.checkCode(this.currentString);
            } else if (this.isValidChar(typedChar) && this.currentString.length() < 20) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("random.click")), 0.15f, 1.0f);
                this.currentString = this.currentString + typedChar;
                this.setTextboxCensoredText(this.keycodeTextbox, this.currentString);
            }
            if (keyCode != 1) {
                return;
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    private boolean isValidChar(char c) {
        for (int i = 0; i < this.allowedChars.length; ++i) {
            if (c != this.allowedChars[i]) continue;
            return true;
        }
        return false;
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ClickButton) {
            ((ClickButton)button).onClick();
        }
    }

    private void addNumberToString(int number) {
        if (this.currentString.length() < 20) {
            this.currentString = this.currentString + "" + number;
            this.setTextboxCensoredText(this.keycodeTextbox, this.currentString);
        }
    }

    private void removeLastCharacter() {
        if (this.currentString.length() > 0) {
            this.currentString = Utils.removeLastChar(this.currentString);
            this.setTextboxCensoredText(this.keycodeTextbox, this.currentString);
        }
    }

    private void setTextboxCensoredText(GuiTextField textField, String text) {
        String x = "";
        for (int i = 1; i <= text.length(); ++i) {
            x = x + "*";
        }
        textField.func_146180_a(x);
    }

    private void toggleChildrenActive(boolean setActive) {
        this.field_146292_n.forEach(button -> {
            button.field_146124_l = setActive;
        });
        this.keycodeTextbox.field_146226_p = setActive;
        this.keycodeTextbox.func_146195_b(setActive);
    }

    public void checkCode(String code) {
        BlockPos pos = ((TileEntity)this.be).func_174877_v();
        if (this.be instanceof IModuleInventory && ((IModuleInventory)((Object)this.be)).isModuleEnabled(ModuleType.SMART)) {
            this.toggleChildrenActive(false);
        }
        this.currentString = "";
        this.keycodeTextbox.func_146180_a("");
        SecurityCraft.network.sendToServer((IMessage)new CheckPassword(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), code));
    }
}

