/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.util.EnumMap;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.SyncLaserSideConfig;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.util.GuiUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class LaserScreen
extends GuiScreen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/block_pocket_manager.png");
    private final boolean hasSmartModule;
    private String smartModuleTooltip;
    private String title;
    private int xSize = 176;
    private int ySize = 194;
    private int leftPos;
    private int topPos;
    private LaserBlockBlockEntity be;
    private EnumMap<EnumFacing, Boolean> sideConfig;

    public LaserScreen(LaserBlockBlockEntity be, EnumMap<EnumFacing, Boolean> sideConfig) {
        this.title = be.func_145748_c_().func_150254_d();
        this.be = be;
        this.sideConfig = sideConfig;
        this.hasSmartModule = be.isModuleEnabled(ModuleType.SMART);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.leftPos = (this.field_146294_l - this.xSize) / 2;
        this.topPos = (this.field_146295_m - this.ySize) / 2;
        if (this.hasSmartModule) {
            this.sideConfig.forEach((dir, enabled) -> {
                CallbackCheckbox checkbox = new CallbackCheckbox(-1, this.leftPos + 10, this.topPos + dir.func_176745_a() * 25 + 30, 20, 20, Utils.localize("gui.securitycraft:laser." + dir.func_176610_l() + "Enabled", new Object[0]).func_150254_d(), (boolean)enabled, newValue -> this.onChangeValue((EnumFacing)dir, (boolean)newValue), 0x404040);
                checkbox.field_146124_l = this.be.isEnabled();
                this.func_189646_b((GuiButton)checkbox);
            });
            this.smartModuleTooltip = Utils.localize("gui.securitycraft:laser.smartModule", new Object[0]).func_150254_d();
        } else {
            this.smartModuleTooltip = Utils.localize("gui.securitycraft:laser.noSmartModule", new Object[0]).func_150254_d();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.leftPos, this.topPos, 0, 0, this.xSize, this.ySize);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.field_146289_q.func_78276_b(this.title, this.leftPos + this.xSize / 2 - this.field_146289_q.func_78256_a(this.title) / 2, this.topPos + 6, 0x404040);
        GuiUtils.renderModuleInfo(ModuleType.SMART, this.smartModuleTooltip, this.hasSmartModule, this.leftPos + 5, this.topPos + 5, this.field_146294_l, this.field_146295_m, mouseX, mouseY);
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ClickButton) {
            ((ClickButton)button).onClick();
        }
    }

    public void onChangeValue(EnumFacing dir, boolean newValue) {
        this.sideConfig.put(dir, newValue);
        SecurityCraft.network.sendToServer((IMessage)new SyncLaserSideConfig(this.be.func_174877_v(), this.sideConfig));
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }
}

