/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.inventory.GenericMenu;
import net.geforcemods.securitycraft.network.server.RemoveSentryFromSRAT;
import net.geforcemods.securitycraft.network.server.SetSentryMode;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.StringHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SentryRemoteAccessToolScreen
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/srat.png");
    private static final ResourceLocation SENTRY_ICONS = new ResourceLocation("securitycraft", "textures/gui/container/sentry_icons.png");
    private ItemStack srat;
    private ClickButton[][] guiButtons = new ClickButton[12][3];
    private String[] names = new String[12];
    private ClickButton[] guiButtonsGlobal = new ClickButton[3];
    private static final int MODE = 0;
    private static final int TARGETS = 1;
    private static final int UNBIND = 2;
    private List<StringHoverChecker> hoverCheckers = new ArrayList<StringHoverChecker>();
    private static final int SENTRY_TRACKING_RANGE = 256;
    private int viewDistance;

    public SentryRemoteAccessToolScreen(InventoryPlayer inventory, ItemStack item, int viewDistance) {
        super((Container)new GenericMenu(inventory, null));
        this.srat = item;
        this.field_146999_f = 440;
        this.field_147000_g = 215;
        this.viewDistance = viewDistance;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int paddingX = 22;
        int paddingY = 25;
        int[] coords = null;
        int id = 0;
        boolean foundSentry = false;
        int[] modeTextureX = new int[]{0, 16, 32};
        int[] targetTextureX = new int[]{48, 64, 80};
        int[] yStarts = new int[]{0, 0, 0};
        this.hoverCheckers.clear();
        for (int i = 0; i < 12; ++i) {
            int x = i / 6 * this.field_146999_f / 2;
            int y = (i % 6 + 1) * 30 + paddingY;
            coords = this.getSentryCoordinates(i);
            for (int j = 0; j < 3; ++j) {
                int btnX = this.field_147003_i + j * paddingX + 147 + x;
                int btnY = this.field_147009_r + y - 48;
                switch (j) {
                    case 0: {
                        this.guiButtons[i][j] = new TogglePictureButton(id++, btnX, btnY, 20, 20, SENTRY_ICONS, modeTextureX, yStarts, 2, 3, this::actionPerformedSingle);
                        this.guiButtons[i][j].field_146124_l = false;
                        break;
                    }
                    case 1: {
                        this.guiButtons[i][j] = new TogglePictureButton(id++, btnX, btnY, 20, 20, SENTRY_ICONS, targetTextureX, yStarts, 2, 3, this::actionPerformedSingle);
                        this.guiButtons[i][j].field_146124_l = false;
                        break;
                    }
                    case 2: {
                        this.guiButtons[i][j] = new ClickButton(id++, btnX, btnY, 20, 20, "X", this::clickUnbind);
                        this.guiButtons[i][j].field_146124_l = false;
                    }
                }
                this.field_146292_n.add(this.guiButtons[i][j]);
            }
            BlockPos sentryPos = new BlockPos(coords[0], coords[1], coords[2]);
            if (coords[0] == 0 && coords[1] == 0 && coords[2] == 0) continue;
            this.guiButtons[i][2].field_146124_l = true;
            if (Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175668_a(sentryPos, false) && this.isSentryVisibleToPlayer(sentryPos)) {
                List sentries = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_72872_a(Sentry.class, new AxisAlignedBB(sentryPos));
                if (!sentries.isEmpty()) {
                    Sentry sentry = (Sentry)sentries.get(0);
                    Sentry.EnumSentryMode mode = sentry.getMode();
                    if (sentry.func_145818_k_()) {
                        String line = Utils.getFormattedCoordinates(new BlockPos(coords[0], coords[1], coords[2])).func_150254_d();
                        int nameWidth = this.field_146289_q.func_78256_a(sentry.func_95999_t());
                        int nameX = this.field_147003_i + this.field_146999_f / 4 - nameWidth + 33 + i / 6 * this.field_146999_f / 2;
                        int nameY = this.field_147009_r + i % 6 * 30 + 7;
                        StringHoverChecker posTooltipText = new StringHoverChecker(nameY + 4, nameY + 18, nameX, nameX + nameWidth + 2, line);
                        this.names[i] = sentry.func_95999_t();
                        this.hoverCheckers.add(posTooltipText);
                    }
                    this.guiButtons[i][0].field_146124_l = true;
                    this.guiButtons[i][1].field_146124_l = mode != Sentry.EnumSentryMode.IDLE;
                    this.guiButtons[i][2].field_146124_l = true;
                    ((TogglePictureButton)this.guiButtons[i][0]).setCurrentIndex(mode.ordinal() / 3);
                    ((TogglePictureButton)this.guiButtons[i][1]).setCurrentIndex(mode.ordinal() % 3);
                    this.hoverCheckers.add(new StringHoverChecker((GuiButton)this.guiButtons[i][0], Arrays.asList(Utils.localize("gui.securitycraft:srat.mode2", new Object[0]).func_150254_d(), Utils.localize("gui.securitycraft:srat.mode1", new Object[0]).func_150254_d(), Utils.localize("gui.securitycraft:srat.mode3", new Object[0]).func_150254_d())));
                    this.hoverCheckers.add(new StringHoverChecker((GuiButton)this.guiButtons[i][1], Arrays.asList(Utils.localize("gui.securitycraft:srat.targets1", new Object[0]).func_150254_d(), Utils.localize("gui.securitycraft:srat.targets2", new Object[0]).func_150254_d(), Utils.localize("gui.securitycraft:srat.targets3", new Object[0]).func_150254_d())));
                    this.hoverCheckers.add(new StringHoverChecker((GuiButton)this.guiButtons[i][2], Utils.localize("gui.securitycraft:srat.unbind", new Object[0]).func_150254_d()));
                    foundSentry = true;
                    continue;
                }
                this.removeTagFromToolAndUpdate(this.srat, coords[0], coords[1], coords[2]);
                for (int j = 0; j < 3; ++j) {
                    this.guiButtons[i][j].field_146124_l = false;
                }
                continue;
            }
            for (int j = 0; j < 2; ++j) {
                this.hoverCheckers.add(new StringHoverChecker((GuiButton)this.guiButtons[i][j], Utils.localize("gui.securitycraft:srat.outOfRange", new Object[0]).func_150254_d()));
            }
            this.hoverCheckers.add(new StringHoverChecker((GuiButton)this.guiButtons[i][2], Utils.localize("gui.securitycraft:srat.unbind", new Object[0]).func_150254_d()));
        }
        this.guiButtonsGlobal[0] = new TogglePictureButton(1000, this.field_147003_i + 260, this.field_147009_r + 188, 20, 20, SENTRY_ICONS, modeTextureX, yStarts, 2, 3, this::actionPerformedGlobal);
        this.guiButtonsGlobal[1] = new TogglePictureButton(1001, this.field_147003_i + 22 + 260, this.field_147009_r + 188, 20, 20, SENTRY_ICONS, targetTextureX, yStarts, 2, 3, this::actionPerformedGlobal);
        this.guiButtonsGlobal[2] = new ClickButton(1002, this.field_147003_i + 44 + 260, this.field_147009_r + 188, 20, 20, "X", this::clickGlobalUnbind);
        for (int j = 0; j < 3; ++j) {
            this.guiButtonsGlobal[j].field_146124_l = foundSentry;
            this.func_189646_b((GuiButton)this.guiButtonsGlobal[j]);
        }
        this.hoverCheckers.add(new StringHoverChecker((GuiButton)this.guiButtonsGlobal[0], Arrays.asList(Utils.localize("gui.securitycraft:srat.mode2", new Object[0]).func_150254_d(), Utils.localize("gui.securitycraft:srat.mode1", new Object[0]).func_150254_d(), Utils.localize("gui.securitycraft:srat.mode3", new Object[0]).func_150254_d())));
        this.hoverCheckers.add(new StringHoverChecker((GuiButton)this.guiButtonsGlobal[1], Arrays.asList(Utils.localize("gui.securitycraft:srat.targets1", new Object[0]).func_150254_d(), Utils.localize("gui.securitycraft:srat.targets2", new Object[0]).func_150254_d(), Utils.localize("gui.securitycraft:srat.targets3", new Object[0]).func_150254_d())));
        this.hoverCheckers.add(new StringHoverChecker((GuiButton)this.guiButtonsGlobal[2], Utils.localize("gui.securitycraft:srat.unbind", new Object[0]).func_150254_d()));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String modifyAll = Utils.localize("gui.securitycraft:srat.modifyAll", new Object[0]).func_150254_d();
        this.field_146289_q.func_78276_b(Utils.localize("item.securitycraft:remoteAccessSentry.name", new Object[0]).func_150254_d(), 5, -12, 0xFF0000);
        for (int i = 0; i < 12; ++i) {
            int[] coords = this.getSentryCoordinates(i);
            String line = coords[0] == 0 && coords[1] == 0 && coords[2] == 0 ? Utils.localize("gui.securitycraft:srat.notBound", new Object[0]).func_150254_d() : (this.names[i] != null ? this.names[i] : Utils.getFormattedCoordinates(new BlockPos(coords[0], coords[1], coords[2])).func_150254_d());
            this.field_146289_q.func_78276_b(line, this.field_146999_f / 4 - this.field_146289_q.func_78256_a(line) + 35 + i / 6 * this.field_146999_f / 2, i % 6 * 30 + 13, 0x404040);
        }
        this.field_146289_q.func_78276_b(modifyAll, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(modifyAll) + 25, 194, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        SentryRemoteAccessToolScreen.func_146110_a((int)startX, (int)startY, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)512.0f, (float)256.0f);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (StringHoverChecker chc : this.hoverCheckers) {
            if (chc == null || !chc.checkHover(mouseX, mouseY)) continue;
            this.func_146279_a(chc.getName(), mouseX, mouseY);
        }
    }

    protected void performSingleAction(int sentry, int mode, int targets) {
        int[] coords = this.getSentryCoordinates(sentry);
        List sentries = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_72872_a(Sentry.class, new AxisAlignedBB(new BlockPos(coords[0], coords[1], coords[2])));
        if (!sentries.isEmpty()) {
            int resultingMode = Math.max(0, Math.min(targets + mode * 3, 6));
            this.guiButtons[sentry][1].field_146124_l = Sentry.EnumSentryMode.values()[resultingMode] != Sentry.EnumSentryMode.IDLE;
            ((Sentry)sentries.get(0)).toggleMode((EntityPlayer)Minecraft.func_71410_x().field_71439_g, resultingMode, false);
            SecurityCraft.network.sendToServer((IMessage)new SetSentryMode(((Sentry)sentries.get(0)).func_180425_c(), resultingMode));
        }
    }

    private void clickUnbind(ClickButton button) {
        this.unbindSentry(button.field_146127_k / 3);
    }

    private void clickGlobalUnbind(ClickButton button) {
        for (int i = 0; i < 12; ++i) {
            this.unbindSentry(i);
        }
    }

    private void unbindSentry(int sentry) {
        int i;
        int[] coords = this.getSentryCoordinates(sentry);
        this.removeTagFromToolAndUpdate(this.srat, coords[0], coords[1], coords[2]);
        for (i = 0; i < 3; ++i) {
            this.guiButtons[sentry][i].field_146124_l = false;
        }
        for (i = 0; i < this.guiButtons.length; ++i) {
            if (!this.guiButtons[i][2].field_146124_l) continue;
            return;
        }
        for (i = 0; i < 3; ++i) {
            this.guiButtonsGlobal[i].field_146124_l = false;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ClickButton) {
            ((ClickButton)button).onClick();
        }
    }

    protected void actionPerformedSingle(ClickButton button) {
        int mode;
        int sentry = button.field_146127_k / 3;
        int type = button.field_146127_k % 3;
        int targets = mode = ((TogglePictureButton)button).getCurrentIndex();
        if (type == 0) {
            targets = ((TogglePictureButton)this.guiButtons[sentry][1]).getCurrentIndex();
        } else if (type == 1) {
            mode = ((TogglePictureButton)this.guiButtons[sentry][0]).getCurrentIndex();
        }
        this.performSingleAction(sentry, mode, targets);
    }

    protected void actionPerformedGlobal(ClickButton button) {
        for (int i = 0; i < this.field_146292_n.size() / 3; ++i) {
            GuiButton buttonFromList = (GuiButton)this.field_146292_n.get(i * 3);
            if (!(buttonFromList instanceof ClickButton) || this.getSentryCoordinates(i)[1] == 0) continue;
            int sentry = ((ClickButton)((Object)this.field_146292_n.get((int)(i * 3)))).field_146127_k / 3;
            int mode = button.field_146127_k == this.guiButtonsGlobal[0].field_146127_k ? ((TogglePictureButton)this.guiButtonsGlobal[0]).getCurrentIndex() : ((TogglePictureButton)this.guiButtons[sentry][0]).getCurrentIndex();
            int targets = button.field_146127_k == this.guiButtonsGlobal[1].field_146127_k ? ((TogglePictureButton)this.guiButtonsGlobal[1]).getCurrentIndex() : ((TogglePictureButton)this.guiButtons[sentry][1]).getCurrentIndex();
            ((TogglePictureButton)this.guiButtons[sentry][0]).setCurrentIndex(mode);
            ((TogglePictureButton)this.guiButtons[sentry][1]).setCurrentIndex(targets);
            this.performSingleAction(sentry, mode, targets);
        }
    }

    private int[] getSentryCoordinates(int sentry) {
        if (this.srat.func_77973_b() != null && this.srat.func_77973_b() == SCContent.remoteAccessSentry && this.srat.func_77978_p() != null && this.srat.func_77978_p().func_74759_k("sentry" + ++sentry) != null && this.srat.func_77978_p().func_74759_k("sentry" + sentry).length > 0) {
            return this.srat.func_77978_p().func_74759_k("sentry" + sentry);
        }
        return new int[]{0, 0, 0};
    }

    private void removeTagFromToolAndUpdate(ItemStack stack, int x, int y, int z) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("sentry" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("sentry" + i))[0] != x || coords[1] != y || coords[2] != z) continue;
            stack.func_77978_p().func_74783_a("sentry" + i, new int[]{0, 0, 0});
            SecurityCraft.network.sendToServer((IMessage)new RemoveSentryFromSRAT(i));
            return;
        }
    }

    private boolean isSentryVisibleToPlayer(BlockPos sentryPos) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double d0 = player.field_70165_t - (double)sentryPos.func_177958_n();
        double d1 = player.field_70161_v - (double)sentryPos.func_177952_p();
        int i = Math.min(256, this.viewDistance) - 1;
        return d0 >= (double)(-i) && d0 <= (double)i && d1 >= (double)(-i) && d1 <= (double)i;
    }
}

