/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.IToggleableEntries;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.lwjgl.input.Mouse;

public class ToggleListScreen<T>
extends GuiScreen {
    private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/blank.png");
    private final int imageWidth = 176;
    private final int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private final String title;
    private final String scrollListTitle;
    private final String smartModuleTooltip;
    private final boolean hasSmartModule;
    private final boolean hasRedstoneModule;
    private IToggleableEntries<T> te;
    private ToggleScrollList entryList;

    public ToggleListScreen(IToggleableEntries<T> te, ITextComponent title, ITextComponent scrollListTitle, ITextComponent noSmartModule, ITextComponent smartModule) {
        this.te = te;
        this.hasSmartModule = te instanceof IModuleInventory && ((IModuleInventory)((Object)te)).isModuleEnabled(ModuleType.SMART);
        this.hasRedstoneModule = te instanceof IModuleInventory && ((IModuleInventory)((Object)te)).isModuleEnabled(ModuleType.REDSTONE);
        this.title = title.func_150254_d();
        this.scrollListTitle = scrollListTitle.func_150254_d();
        this.smartModuleTooltip = (this.hasSmartModule ? smartModule : noSmartModule).func_150254_d();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.leftPos = (this.field_146294_l - 176) / 2;
        this.topPos = (this.field_146295_m - 166) / 2;
        this.entryList = new ToggleScrollList(this.field_146297_k, 152, 106, this.topPos + 40, this.leftPos + 12, this.field_146294_l, this.field_146295_m);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_73729_b(this.leftPos, this.topPos, 0, 0, 176, 166);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        if (this.entryList != null) {
            this.entryList.drawScreen(mouseX, mouseY, partialTicks);
        }
        this.field_146289_q.func_78276_b(this.title, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(this.title) / 2, this.topPos + 6, 0x404040);
        this.field_146289_q.func_78276_b(this.scrollListTitle, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(this.scrollListTitle) / 2, this.topPos + 31, 0x404040);
        net.geforcemods.securitycraft.util.GuiUtils.renderModuleInfo(ModuleType.SMART, this.smartModuleTooltip, this.hasSmartModule, this.leftPos + 5, this.topPos + 5, this.field_146294_l, this.field_146295_m, mouseX, mouseY);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.entryList.handleMouseInput(mouseX, mouseY);
    }

    public boolean func_73868_f() {
        return false;
    }

    class ToggleScrollList
    extends GuiScrollingList {
        private int hoveredSlot;
        private int slotTop;
        private final List<T> orderedFilterList;
        private final Map<T, ITextComponent> typeNames;

        public ToggleScrollList(Minecraft client, int width, int height, int top, int left, int screenWidth, int screenHeight) {
            super(client, width, height, top, top + height, left, 12, screenWidth, screenHeight);
            this.hoveredSlot = -1;
            this.slotTop = -1;
            this.typeNames = new HashMap();
            this.orderedFilterList = new ArrayList(ToggleListScreen.this.te.getFilters().keySet());
            this.orderedFilterList.sort((e1, e2) -> {
                if (e1 == ToggleListScreen.this.te.getDefaultType()) {
                    return 1;
                }
                if (e2 == ToggleListScreen.this.te.getDefaultType()) {
                    return -1;
                }
                return ToggleListScreen.this.te.getTypeName(e1).compareTo(ToggleListScreen.this.te.getTypeName(e2));
            });
        }

        protected int getSize() {
            return this.orderedFilterList.size();
        }

        protected boolean isSelected(int index) {
            return ToggleListScreen.this.hasSmartModule && index == this.hoveredSlot;
        }

        protected void drawBackground() {
        }

        protected int getContentHeight() {
            int height = this.getSize() * (((ToggleListScreen)ToggleListScreen.this).field_146289_q.field_78288_b + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            return height;
        }

        protected void elementClicked(int index, boolean doubleClick) {
            if (ToggleListScreen.this.hasSmartModule) {
                ToggleListScreen.this.te.toggleFilter(this.orderedFilterList.get(index));
                ToggleListScreen.this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
        }

        public void drawScreen(int mouseX, int mouseY, float partialTicks) {
            int comparatorOutput;
            super.drawScreen(mouseX, mouseY, partialTicks);
            int slotBottom = this.slotTop + this.slotHeight;
            if (ToggleListScreen.this.hasRedstoneModule && mouseX >= this.left && mouseX <= this.right - 7 && this.hoveredSlot >= 0 && this.hoveredSlot < this.getSize() && mouseY >= this.top && mouseY <= this.bottom && (comparatorOutput = ToggleListScreen.this.te.getComparatorOutputFunction().applyAsInt(this.orderedFilterList.get(this.hoveredSlot))) > 0) {
                GuiUtils.drawHoveringText(Collections.singletonList(Utils.localize("gui.securitycraft:toggleList.comparatorOutput", comparatorOutput).func_150254_d()), (int)(this.right - 8), (int)slotBottom, (int)this.screenWidth, (int)this.screenHeight, (int)-1, (FontRenderer)ToggleListScreen.this.field_146297_k.field_71466_p);
                RenderHelper.func_74518_a();
            }
        }

        protected void drawSlot(int slotIndex, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
            if (this.mouseX >= this.left && this.mouseX <= entryRight && slotIndex >= 0 && slotIndex < this.getSize() && this.mouseY >= slotTop - 1 && this.mouseY <= slotTop + slotBuffer + 2) {
                this.hoveredSlot = slotIndex;
                this.slotTop = slotTop;
            } else if (this.mouseX < this.left || this.mouseX > this.right || this.mouseY < this.top || this.mouseY > this.bottom || this.mouseY > this.top + this.slotHeight * this.getSize()) {
                this.hoveredSlot = -1;
            }
            Object type = this.orderedFilterList.get(slotIndex);
            String name = this.typeNames.computeIfAbsent(type, t -> Utils.localize(t == ToggleListScreen.this.te.getDefaultType() ? ToggleListScreen.this.te.getDefaultTypeName() : ToggleListScreen.this.te.getTypeName(t), new Object[0])).func_150254_d();
            ToggleListScreen.this.field_146289_q.func_78276_b(name, this.left + this.listWidth / 2 - ToggleListScreen.this.field_146289_q.func_78256_a(name) / 2, slotTop, 0xC6C6C6);
            ToggleListScreen.this.field_146297_k.func_110434_K().func_110577_a(BEACON_GUI);
            Gui.func_152125_a((int)this.left, (int)(slotTop - 3), (float)(ToggleListScreen.this.te.getFilter(type) ? 88.0f : 110.0f), (float)219.0f, (int)21, (int)22, (int)14, (int)14, (float)256.0f, (float)256.0f);
        }
    }
}

