/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.client.config.GuiUtils;

public class CollapsibleTextList
extends ClickButton {
    private static final TextComponentString PLUS = new TextComponentString("+ ");
    private static final TextComponentString MINUS = new TextComponentString("- ");
    private final int threeDotsWidth;
    private final int maximumHeight;
    private int currentHeight;
    private int previousHeight;
    private final String originalDisplayString;
    private final List<List<String>> textLines;
    private final BiPredicate<Integer, Integer> extraHoverCheck;
    private boolean open;
    private boolean isMessageTooLong;
    private int initialY;

    public CollapsibleTextList(int id, int x, int y, int width, String buttonText, List<? extends ITextComponent> textLines, Consumer<CollapsibleTextList> onPress, BiPredicate<Integer, Integer> extraHoverCheck) {
        super(id, x, y, width, 12, buttonText, clickButton -> onPress.accept((CollapsibleTextList)((Object)((Object)clickButton))));
        this.threeDotsWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a("...");
        this.textLines = new ArrayList<List<String>>();
        this.open = true;
        this.isMessageTooLong = false;
        this.initialY = -1;
        this.originalDisplayString = buttonText;
        this.switchOpenStatus();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int amountOfLines = 0;
        for (ITextComponent iTextComponent : textLines) {
            List splitLines = font.func_78271_c(iTextComponent.func_150254_d(), width - 5);
            amountOfLines += splitLines.size();
            this.textLines.add(splitLines);
        }
        this.maximumHeight = this.field_146121_g + amountOfLines * font.field_78288_b + textLines.size() * 3;
        this.currentHeight = this.previousHeight = this.field_146121_g;
        this.extraHoverCheck = extraHoverCheck;
    }

    public void tick() {
        this.previousHeight = this.currentHeight;
        if (this.open) {
            if (this.currentHeight < this.maximumHeight) {
                this.currentHeight = Math.min(this.currentHeight + 40, this.maximumHeight);
            }
        } else if (this.currentHeight > this.field_146121_g) {
            this.currentHeight = Math.max(this.field_146121_g, this.currentHeight - 40);
        }
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g && this.extraHoverCheck.test(mouseX, mouseY);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int v = this.func_146114_a(this.func_146115_a());
        int heightOffset = (this.field_146121_g - 8) / 2;
        int renderedLines = 0;
        int interpolatedHeight = this.previousHeight + MathHelper.func_76141_d((float)(partialTicks * (float)(this.previousHeight - this.currentHeight)));
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_146122_a, (int)this.field_146128_h, (int)this.field_146129_i, (int)0, (int)(46 + v * 20), (int)this.field_146120_f, (int)this.field_146121_g, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
        this.func_73732_a(font, this.field_146126_j, this.field_146128_h + font.func_78256_a(this.field_146126_j) / 2 + 3, this.field_146129_i + heightOffset, 0xE0E0E0);
        GuiUtils.drawGradientRect((int)0, (int)this.field_146128_h, (int)(this.field_146129_i + this.field_146121_g), (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + interpolatedHeight), (int)-1072689136, (int)-804253680);
        for (int i = 0; i < this.textLines.size(); ++i) {
            int textY = this.field_146129_i + 2 + this.field_146121_g + renderedLines * font.field_78288_b + i * 12;
            List<String> linesToDraw = this.textLines.get(i);
            if (i > 0) {
                GuiUtils.drawGradientRect((int)((int)this.field_73735_i), (int)(this.field_146128_h + 1), (int)(textY - 3), (int)(this.field_146128_h + this.field_146120_f - 2), (int)(textY - 2), (int)-1432313696, (int)-1432313696);
            }
            for (int lineIndex = 0; lineIndex < linesToDraw.size(); ++lineIndex) {
                int lineY = textY + lineIndex * font.field_78288_b;
                if (lineY + font.field_78288_b > this.field_146129_i + interpolatedHeight) {
                    return;
                }
                font.func_78276_b(linesToDraw.get(lineIndex), this.field_146128_h + 2, lineY, 0xE0E0E0);
            }
            renderedLines += linesToDraw.size() - 1;
        }
    }

    public void renderLongMessageTooltip() {
        GuiScreen currentScreen;
        if (this.isMessageTooLong && this.func_146115_a() && (currentScreen = Minecraft.func_71410_x().field_71462_r) != null) {
            currentScreen.func_146279_a(this.originalDisplayString, this.field_146128_h + 1, this.field_146129_i + this.field_146121_g + 2);
        }
    }

    public void setMessage(ITextComponent message) {
        int cutoff;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String newDisplayString = message.func_150254_d();
        int stringWidth = font.func_78256_a(newDisplayString);
        if (stringWidth > (cutoff = this.field_146120_f - 6) && stringWidth > this.threeDotsWidth) {
            this.isMessageTooLong = true;
            newDisplayString = font.func_78269_a(newDisplayString, cutoff - this.threeDotsWidth) + "...";
        }
        this.field_146126_j = newDisplayString;
    }

    public void setHeight(int height) {
        this.field_146121_g = height;
    }

    public int getHeight() {
        return this.currentHeight;
    }

    public int getMaximumHeight() {
        return this.open ? this.maximumHeight : this.field_146121_g;
    }

    @Override
    public void onClick() {
        this.switchOpenStatus();
        super.onClick();
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        return this.extraHoverCheck.test(mouseX, mouseY) && super.func_146116_c(mc, mouseX, mouseY);
    }

    public void setY(int y) {
        if (this.initialY == -1) {
            this.initialY = y;
        }
        this.field_146129_i = y;
    }

    public void switchOpenStatus() {
        this.open = !this.open;
        this.setMessage((this.open ? MINUS : PLUS).func_150259_f().func_150257_a((ITextComponent)new TextComponentString(this.originalDisplayString)));
    }

    public boolean isOpen() {
        return this.open;
    }

    public int getInitialY() {
        return this.initialY;
    }
}

