/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import java.util.function.Consumer;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.IToggleableButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;

public class TogglePictureButton
extends ClickButton
implements IToggleableButton {
    private ResourceLocation textureLocation;
    private int[] u;
    private int[] v;
    private int currentIndex = 0;
    private final int toggleCount;
    private final int drawOffset;
    private final int drawWidth;
    private final int drawHeight;
    private final int uWidth;
    private final int vHeight;
    private final int textureWidth;
    private final int textureHeight;

    public TogglePictureButton(int id, int xPos, int yPos, int width, int height, ResourceLocation texture, int[] textureX, int[] textureY, int drawOffset, int toggleCount, Consumer<ClickButton> onClick) {
        this(id, xPos, yPos, width, height, texture, textureX, textureY, drawOffset, 16, 16, 16, 16, 256, 256, toggleCount, onClick);
    }

    public TogglePictureButton(int id, int xPos, int yPos, int width, int height, ResourceLocation texture, int[] textureX, int[] textureY, int drawOffset, int drawWidth, int drawHeight, int uWidth, int vHeight, int textureWidth, int textureHeight, int toggleCount, Consumer<ClickButton> onClick) {
        super(id, xPos, yPos, width, height, "", onClick);
        if (textureX.length != toggleCount || textureY.length != toggleCount) {
            throw new RuntimeException("GuiTogglePictureButton was set up incorrectly. Array lengths must match toggleCount!");
        }
        this.toggleCount = toggleCount;
        this.textureLocation = texture;
        this.u = textureX;
        this.v = textureY;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.drawOffset = drawOffset;
        this.drawWidth = drawWidth;
        this.drawHeight = drawHeight;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_146122_a, (int)this.field_146128_h, (int)this.field_146129_i, (int)0, (int)(46 + this.func_146114_a(this.field_146123_n) * 20), (int)this.field_146120_f, (int)this.field_146121_g, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.field_73735_i);
            if (this.getTextureLocation() != null) {
                mc.func_110434_K().func_110577_a(this.getTextureLocation());
                TogglePictureButton.func_152125_a((int)(this.field_146128_h + this.drawOffset), (int)(this.field_146129_i + this.drawOffset), (float)this.u[this.currentIndex], (float)this.v[this.currentIndex], (int)this.uWidth, (int)this.vHeight, (int)this.drawWidth, (int)this.drawHeight, (float)this.textureWidth, (float)this.textureHeight);
            }
        }
    }

    @Override
    public void onClick() {
        this.setCurrentIndex(this.currentIndex + 1);
        super.onClick();
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public void setCurrentIndex(int newIndex) {
        this.currentIndex = newIndex % this.toggleCount;
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }
}

