/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.util;

import com.google.common.base.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Pair<X, Y> {
    private final X left;
    private final Y right;

    public static <X, Y> Pair<X, Y> of(X left, Y right) {
        return new Pair<X, Y>(left, right);
    }

    public Pair(X left, Y right) {
        this.left = left;
        this.right = right;
    }

    public X left() {
        return this.left;
    }

    public Y right() {
        return this.right;
    }

    public <S> Pair<S, Y> mapLeft(Function<X, S> mapper) {
        return Pair.of(mapper.apply(this.left), this.right);
    }

    public <S> Pair<X, S> mapRight(Function<Y, S> mapper) {
        return Pair.of(this.left, mapper.apply(this.right));
    }

    public <R, S> Pair<R, S> map(Function<X, R> mapLeft, Function<Y, S> mapRight) {
        return Pair.of(mapLeft.apply(this.left), mapRight.apply(this.right));
    }

    public <S> S flatMap(BiFunction<X, Y, S> mapper) {
        return mapper.apply(this.left, this.right);
    }

    public void apply(BiConsumer<X, Y> consumer) {
        consumer.accept(this.left, this.right);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return Objects.equal(this.left, pair.left) && Objects.equal(this.right, pair.right);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.left, this.right});
    }
}

