/*
 * Decompiled with CFR 0.152.
 */
package com.kamildanak.minecraft.foamflower.gui;

import com.kamildanak.minecraft.foamflower.Utils;
import com.kamildanak.minecraft.foamflower.gui.IGuiWrapper;
import com.kamildanak.minecraft.foamflower.gui.elements.GuiElement;
import com.kamildanak.minecraft.foamflower.gui.input.InputKeyboardEvent;
import com.kamildanak.minecraft.foamflower.gui.input.InputMouseEvent;
import com.kamildanak.minecraft.foamflower.gui.layouts.AbsoluteLayout;
import com.kamildanak.minecraft.foamflower.inventory.DummyContainer;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiScreenPlus
extends GuiContainer
implements IGuiWrapper {
    public int screenW;
    public int screenH;
    public int screenX;
    public int screenY;
    public GuiElement root;
    String backgroundTexture;
    InputMouseEvent mouseEvent = new InputMouseEvent();
    int oldX = -1;
    int oldY = -1;
    boolean[] downButtons = new boolean[12];
    InputKeyboardEvent keyboardEvent = new InputKeyboardEvent();

    public GuiScreenPlus(Container container, int w, int h, String backgroundTexture) {
        super(container);
        this.root = new AbsoluteLayout(0, 0);
        this.root.gui = this;
        this.screenW = w;
        this.screenH = h;
        this.backgroundTexture = backgroundTexture;
    }

    public GuiScreenPlus(int w, int h, String backgroundTexture) {
        this(new DummyContainer(), w, h, backgroundTexture);
    }

    public void func_73866_w_() {
        this.field_146999_f = this.screenW;
        this.field_147000_g = this.screenH;
        super.func_73866_w_();
        this.screenX = this.field_147003_i;
        this.screenY = this.field_147009_r;
        this.root.onAdded();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_146269_k() throws IOException {
        while (Mouse.next()) {
            this.func_146274_d();
        }
        while (Keyboard.next()) {
            this.func_146282_l();
        }
    }

    public void func_146274_d() throws IOException {
        this.mouseEvent.handled = false;
        this.mouseEvent.x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.screenX;
        this.mouseEvent.y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.screenY;
        if (this.oldX == -1) {
            this.oldX = this.mouseEvent.x;
            this.oldY = this.mouseEvent.y;
        }
        this.mouseEvent.dx = this.mouseEvent.x - this.oldX;
        this.mouseEvent.dy = this.mouseEvent.y - this.oldY;
        this.oldX = this.mouseEvent.x;
        this.oldY = this.mouseEvent.y;
        this.mouseEvent.down = Mouse.getEventButtonState();
        this.mouseEvent.button = Mouse.getEventButton();
        this.mouseEvent.wheel = Mouse.getEventDWheel();
        if (this.mouseEvent.wheel != 0) {
            this.mouseEvent.wheel = this.mouseEvent.wheel < 0 ? -1 : 1;
            this.root.mouseWheel(this.mouseEvent);
        } else if (this.mouseEvent.button >= 0 && this.mouseEvent.button < this.downButtons.length) {
            if (this.downButtons[this.mouseEvent.button] != this.mouseEvent.down) {
                this.downButtons[this.mouseEvent.button] = this.mouseEvent.down;
                if (this.mouseEvent.down) {
                    this.root.mouseDown(this.mouseEvent);
                } else {
                    this.root.mouseUp(this.mouseEvent);
                }
            } else if (this.mouseEvent.dx != 0 || this.mouseEvent.dy != 0) {
                this.root.mouseMove(this.mouseEvent);
            }
        } else if (this.mouseEvent.dx != 0 || this.mouseEvent.dy != 0) {
            this.root.mouseMove(this.mouseEvent);
        }
        if (!this.mouseEvent.handled) {
            super.func_146274_d();
        }
    }

    public void func_146282_l() throws IOException {
        this.keyboardEvent.handled = false;
        if (Keyboard.getEventKeyState()) {
            this.keyboardEvent.key = Keyboard.getEventKey();
            this.keyboardEvent.character = Keyboard.getEventCharacter();
            switch (this.keyboardEvent.key) {
                case 1: {
                    break;
                }
                default: {
                    this.root.keyPressed(this.keyboardEvent);
                }
            }
        }
        if (!this.keyboardEvent.handled) {
            super.func_146282_l();
        }
    }

    public void close() {
        this.field_146297_k.func_147108_a(null);
        this.field_146297_k.func_71381_h();
    }

    protected void addChild(GuiElement e) {
        this.root.addChild(e);
    }

    protected void func_146976_a(float f, int bx, int by) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.backgroundTexture);
        this.func_73729_b(this.screenX, this.screenY, 0, 0, this.screenW, this.screenH);
    }

    protected void func_146979_b(int fx, int fy) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.root.render();
    }

    @Override
    public void drawString(String text, int sx, int sy, int color) {
        FontRenderer fontRenderer = this.field_146289_q;
        fontRenderer.func_78276_b(text, sx, sy, color);
    }

    @Override
    public void drawCenteredString(String text, int sx, int sy, int color) {
        FontRenderer fontRenderer = this.field_146289_q;
        fontRenderer.func_78276_b(text, sx - fontRenderer.func_78256_a(text) / 2, sy - fontRenderer.field_78288_b / 2, color);
    }

    public void drawStringWithShadow(String text, int sx, int sy, int color) {
        FontRenderer fontRenderer = this.field_146289_q;
        fontRenderer.func_175063_a(text, (float)sx, (float)sy, color);
    }

    public void drawCenteredStringWithShadow(String text, int sx, int sy, int color) {
        FontRenderer fontRenderer = this.field_146289_q;
        fontRenderer.func_175063_a(text, (float)(sx - fontRenderer.func_78256_a(text) / 2), (float)(sy - fontRenderer.field_78288_b / 2), color);
    }

    @Override
    public FontRenderer fontRenderer() {
        return this.field_146297_k.field_71466_p;
    }

    protected void drawRect(int gx, int gy, int gw, int gh, int c1, int c2) {
        this.func_73733_a(gx, gy, gx + gw, gy + gh, c1, c2);
    }

    @Override
    public void drawTiledRect(int rx, int ry, int rw, int rh, int u, int v, int tw, int th) {
        if (rw == 0 || rh == 0 || tw == 0 || th == 0) {
            return;
        }
        for (int y = 0; y < rh; y += th) {
            for (int x = 0; x < rw; x += tw) {
                int qh;
                int qw = tw;
                if (x + qw > rw) {
                    qw = rw - x;
                }
                if (y + (qh = th) > rh) {
                    qh = rh - y;
                }
                int x1 = rx + x;
                int w = x + qw;
                int y1 = ry + y;
                int h = y + qh;
                this.func_73729_b(x1, y1, u, v, w, h);
            }
        }
    }

    @Override
    public void bindTexture(String tex) {
        Utils.bind(tex);
    }

    @Override
    public Minecraft getMinecraft() {
        return this.field_146297_k;
    }

    @Override
    public void drawTexturedRectangle(int x, int y, int textureX, int textureY, int width, int height) {
        super.func_73729_b(x, y, textureX, textureY, width, height);
    }
}

