/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.content;

import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.KeyboardData;
import de.keksuccino.konkrete.input.KeyboardHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.math.MathUtils;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class AdvancedTextField
extends GuiTextField {
    private int tick = 0;
    private boolean handleSelf;
    private CharacterFilter filter;
    private boolean leftDown = false;

    public AdvancedTextField(FontRenderer fontRenderer, int x, int y, int width, int height, boolean handleSelf, @Nullable CharacterFilter filter) {
        super(MathUtils.getRandomNumberInRange(50, 400), fontRenderer, x, y, width, height);
        this.handleSelf = handleSelf;
        this.filter = filter;
        if (this.handleSelf) {
            KeyboardHandler.addKeyPressedListener(this::onKeyPress);
        }
    }

    public void func_146194_f() {
        super.func_146194_f();
        if (this.handleSelf) {
            this.func_146178_a();
            if (MouseInput.isLeftMouseDown() && !this.leftDown) {
                this.func_146192_a(MouseInput.getMouseX(), MouseInput.getMouseY(), 0);
                this.leftDown = true;
            }
            if (!MouseInput.isLeftMouseDown()) {
                this.leftDown = false;
            }
        }
    }

    public void func_146191_b(String textToWrite) {
        if (this.filter != null) {
            textToWrite = this.filter.filterForAllowedChars(textToWrite);
        }
        super.func_146191_b(textToWrite);
    }

    public boolean isHovered() {
        int mouseX = MouseInput.getMouseX();
        int mouseY = MouseInput.getMouseY();
        return mouseX >= this.field_146209_f && mouseX <= this.field_146209_f + this.field_146218_h && mouseY >= this.field_146210_g && mouseY <= this.field_146210_g + this.field_146219_i;
    }

    public boolean isEditable() {
        try {
            Field f = ObfuscationReflectionHelper.findField(GuiTextField.class, (String)"field_146226_p");
            return f.getBoolean((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isLeftClicked() {
        return this.isHovered() && MouseInput.isLeftMouseDown();
    }

    public void onKeyPress(KeyboardData d) {
        this.func_146201_a(d.typedChar, d.keycode);
    }

    @Deprecated
    public boolean isEnabled() {
        return this.isEditable();
    }
}

