/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.repackage.com.elytradev.concrete.block;

import com.elytradev.movingworld.repackage.com.elytradev.concrete.block.ExpDropBehaviour;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.block.ItemDropBehaviour;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.common.ShadingValidator;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ConcreteBlock
extends Block {
    private final boolean concreteTranslucent;
    private final boolean silkHarvest;
    private final ItemDropBehaviour itemDropBehaviour;
    private final ExpDropBehaviour expDropBehaviour;

    public static Builder builder() {
        return new Builder();
    }

    private ConcreteBlock(String identifier, Material materialIn, boolean translucent, boolean silkHarvest, ItemDropBehaviour itemDropBehaviour, ExpDropBehaviour expDropBehaviour) {
        super(materialIn);
        this.concreteTranslucent = translucent;
        this.silkHarvest = silkHarvest;
        this.itemDropBehaviour = itemDropBehaviour;
        this.expDropBehaviour = expDropBehaviour;
        this.setRegistryName(identifier);
        this.func_149663_c(Loader.instance().activeModContainer().getModId().toLowerCase() + "." + identifier);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.itemDropBehaviour.getDrop().isPresent()) {
            return this.itemDropBehaviour.getDrop().get().get();
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public int func_149745_a(Random random) {
        return this.itemDropBehaviour.getQuantityDropped(random);
    }

    public int func_149679_a(int fortune, Random random) {
        return this.itemDropBehaviour.getQuantityDroppedWithBonus(fortune, random);
    }

    public int func_180651_a(IBlockState state) {
        return this.itemDropBehaviour.getMeta(this, state);
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        return this.expDropBehaviour.getQuantityDropped(state, world, pos, fortune);
    }

    protected boolean func_149700_E() {
        return this.silkHarvest;
    }

    public Block func_149672_a(SoundType sound) {
        return super.func_149672_a(sound);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        if (this.concreteTranslucent) {
            return BlockRenderLayer.TRANSLUCENT;
        }
        return super.func_180664_k();
    }

    public boolean func_149686_d(IBlockState state) {
        if (this.concreteTranslucent) {
            return false;
        }
        return super.func_149686_d(state);
    }

    public boolean func_149662_c(IBlockState state) {
        if (this.concreteTranslucent) {
            return false;
        }
        return super.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (this.concreteTranslucent) {
            IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
            Block block = iblockstate.func_177230_c();
            return blockState != iblockstate || block != this && super.func_176225_a(blockState, blockAccess, pos, side);
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    static {
        ShadingValidator.ensureShaded();
    }

    public static final class Builder {
        private String identifier;
        private Optional<CreativeTabs> creativeTab = Optional.empty();
        private Material material = Material.field_151576_e;
        private boolean translucent = false;
        private boolean silkHarvest = false;
        private Optional<SoundType> soundType = Optional.empty();
        private ItemDropBehaviour itemDropBehaviour = ItemDropBehaviour.DEFAULT;
        private ExpDropBehaviour expDropBehaviour = ExpDropBehaviour.DEFAULT;
        private Optional<Float> hardness = Optional.empty();
        private Optional<Float> resistance = Optional.empty();

        private Builder() {
        }

        public Builder preset(Consumer<Builder> preset) {
            preset.accept(this);
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder creativeTab(CreativeTabs creativeTab) {
            this.creativeTab = Optional.of(creativeTab);
            return this;
        }

        public Builder material(Material material) {
            this.material = material;
            return this;
        }

        public Builder translucent() {
            this.translucent = true;
            return this;
        }

        public Builder silkHarvest() {
            this.silkHarvest = true;
            return this;
        }

        public Builder soundType(SoundType soundType) {
            this.soundType = Optional.of(soundType);
            return this;
        }

        public Builder drop(ItemDropBehaviour dropBehaviour) {
            this.itemDropBehaviour = dropBehaviour;
            return this;
        }

        public Builder drop(ExpDropBehaviour dropBehaviour) {
            this.expDropBehaviour = dropBehaviour;
            return this;
        }

        public Builder hardness(float hardness) {
            this.hardness = Optional.of(Float.valueOf(hardness));
            return this;
        }

        public Builder resistance(float resistance) {
            this.resistance = Optional.of(Float.valueOf(resistance));
            return this;
        }

        public ConcreteBlock build() {
            Preconditions.checkNotNull((Object)this.identifier, (Object)"An identifier is required to build a block!");
            ConcreteBlock block = new ConcreteBlock(this.identifier, this.material, this.translucent, this.silkHarvest, this.itemDropBehaviour, this.expDropBehaviour);
            this.creativeTab.ifPresent(arg_0 -> ((ConcreteBlock)block).func_149647_a(arg_0));
            this.hardness.ifPresent(arg_0 -> ((ConcreteBlock)block).func_149711_c(arg_0));
            this.resistance.ifPresent(arg_0 -> ((ConcreteBlock)block).func_149752_b(arg_0));
            this.soundType.ifPresent(block::func_149672_a);
            return block;
        }
    }
}

