/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class ArrayUtils {
    public static boolean contains(Object[] arr2, Object val) {
        if (arr2 == null) {
            return false;
        }
        for (int i = 0; i < arr2.length; ++i) {
            Object obj = arr2[i];
            if (obj != val) continue;
            return true;
        }
        return false;
    }

    public static int[] addIntsToArray(int[] intArray, int[] copyFrom) {
        if (intArray == null || copyFrom == null) {
            throw new NullPointerException("The given array is NULL");
        }
        int arrLen = intArray.length;
        int newLen = arrLen + copyFrom.length;
        int[] newArray = new int[newLen];
        System.arraycopy(intArray, 0, newArray, 0, arrLen);
        for (int index = 0; index < copyFrom.length; ++index) {
            newArray[index + arrLen] = copyFrom[index];
        }
        return newArray;
    }

    public static int[] addIntToArray(int[] intArray, int intValue) {
        return ArrayUtils.addIntsToArray(intArray, new int[]{intValue});
    }

    public static Object[] addObjectsToArray(Object[] arr2, Object[] objs) {
        if (arr2 == null) {
            throw new NullPointerException("The given array is NULL");
        }
        if (objs.length == 0) {
            return arr2;
        }
        int arrLen = arr2.length;
        int newLen = arrLen + objs.length;
        Object[] newArr = (Object[])Array.newInstance(arr2.getClass().getComponentType(), newLen);
        System.arraycopy(arr2, 0, newArr, 0, arrLen);
        System.arraycopy(objs, 0, newArr, arrLen, objs.length);
        return newArr;
    }

    public static Object[] addObjectToArray(Object[] arr2, Object obj) {
        if (arr2 == null) {
            throw new NullPointerException("The given array is NULL");
        }
        int arrLen = arr2.length;
        int newLen = arrLen + 1;
        Object[] newArr = (Object[])Array.newInstance(arr2.getClass().getComponentType(), newLen);
        System.arraycopy(arr2, 0, newArr, 0, arrLen);
        newArr[arrLen] = obj;
        return newArr;
    }

    public static Object[] addObjectToArray(Object[] arr2, Object obj, int index) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arr2));
        list.add(index, obj);
        Object[] newArr = (Object[])Array.newInstance(arr2.getClass().getComponentType(), list.size());
        return list.toArray(newArr);
    }

    public static String arrayToString(boolean[] arr2, String separator) {
        if (arr2 == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr2.length * 5);
        for (int i = 0; i < arr2.length; ++i) {
            boolean x = arr2[i];
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(x));
        }
        return buf.toString();
    }

    public static String arrayToString(float[] arr2) {
        return ArrayUtils.arrayToString(arr2, ", ");
    }

    public static String arrayToString(float[] arr2, String separator) {
        if (arr2 == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr2.length * 5);
        for (int i = 0; i < arr2.length; ++i) {
            float x = arr2[i];
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(x));
        }
        return buf.toString();
    }

    public static String arrayToString(float[] arr2, String separator, String format) {
        if (arr2 == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr2.length * 5);
        for (int i = 0; i < arr2.length; ++i) {
            float x = arr2[i];
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(String.format(format, Float.valueOf(x)));
        }
        return buf.toString();
    }

    public static String arrayToString(int[] arr2) {
        return ArrayUtils.arrayToString(arr2, ", ");
    }

    public static String arrayToString(int[] arr2, String separator) {
        if (arr2 == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr2.length * 5);
        for (int i = 0; i < arr2.length; ++i) {
            int x = arr2[i];
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(x));
        }
        return buf.toString();
    }

    public static String arrayToHexString(int[] arr2, String separator) {
        if (arr2 == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr2.length * 5);
        for (int i = 0; i < arr2.length; ++i) {
            int x = arr2[i];
            if (i > 0) {
                buf.append(separator);
            }
            buf.append("0x");
            buf.append(Integer.toHexString(x));
        }
        return buf.toString();
    }

    public static String arrayToString(Object[] arr2) {
        return ArrayUtils.arrayToString(arr2, ", ");
    }

    public static String arrayToString(Object[] arr2, String separator) {
        if (arr2 == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr2.length * 5);
        for (int i = 0; i < arr2.length; ++i) {
            Object obj = arr2[i];
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(obj));
        }
        return buf.toString();
    }

    public static Object[] collectionToArray(Collection coll, Class elementClass) {
        if (coll == null) {
            return null;
        }
        if (elementClass == null) {
            return null;
        }
        if (elementClass.isPrimitive()) {
            throw new IllegalArgumentException("Can not make arrays with primitive elements (int, double), element class: " + elementClass);
        }
        Object[] array = (Object[])Array.newInstance(elementClass, coll.size());
        return coll.toArray(array);
    }

    public static boolean equalsOne(int val, int[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] != val) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsOne(Object a2, Object[] bs) {
        if (bs == null) {
            return false;
        }
        for (int i = 0; i < bs.length; ++i) {
            Object b2 = bs[i];
            if (!ArrayUtils.equals(a2, b2)) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean isSameOne(Object a2, Object[] bs) {
        if (bs == null) {
            return false;
        }
        for (int i = 0; i < bs.length; ++i) {
            Object b2 = bs[i];
            if (a2 != b2) continue;
            return true;
        }
        return false;
    }

    public static Object[] removeObjectFromArray(Object[] arr2, Object obj) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arr2));
        list.remove(obj);
        Object[] newArr = ArrayUtils.collectionToArray(list, arr2.getClass().getComponentType());
        return newArr;
    }

    public static int[] toPrimitive(Integer[] arr2) {
        if (arr2 == null) {
            return null;
        }
        if (arr2.length == 0) {
            return new int[0];
        }
        int[] intArr = new int[arr2.length];
        for (int i = 0; i < intArr.length; ++i) {
            intArr[i] = arr2[i];
        }
        return intArr;
    }
}

